/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap;

import com.microsoft.applicationinsights.agent.bootstrap.MicrometerUtil;
import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BytecodeUtil {
    private static BytecodeUtilDelegate delegate;
    private static final ThreadLocal<Long> startNanosHolder;

    public static void setDelegate(final BytecodeUtilDelegate delegate) {
        if (BytecodeUtil.delegate == null) {
            BytecodeUtil.delegate = delegate;
            MicrometerUtil.setDelegate(new MicrometerUtil.MicrometerUtilDelegate(){

                @Override
                public void trackMetric(String name, double value, Integer count, Double min, Double max, Map<String, String> properties) {
                    delegate.trackMetric(null, name, null, value, count, min, max, null, properties, Collections.emptyMap(), null, null);
                }
            });
        }
    }

    public static void setConnectionString(String connectionString) {
        if (delegate != null) {
            delegate.setConnectionString(connectionString);
        }
    }

    public static void trackEvent(@Nullable Date timestamp, String name, Map<String, String> properties, Map<String, String> tags, Map<String, Double> metrics, @Nullable String connectionString, @Nullable String instrumentationKey) {
        if (delegate != null) {
            delegate.trackEvent(timestamp, name, properties, tags, metrics, connectionString, instrumentationKey);
        }
    }

    public static void trackMetric(@Nullable Date timestamp, String name, @Nullable String namespace, double value, Integer count, Double min, Double max, @Nullable Double stdDev, Map<String, String> properties, Map<String, String> tags, @Nullable String connectionString, @Nullable String instrumentationKey) {
        if (delegate != null) {
            delegate.trackMetric(timestamp, name, namespace, value, count, min, max, stdDev, properties, tags, connectionString, instrumentationKey);
        }
    }

    public static void trackDependency(@Nullable Date timestamp, String name, String id, String resultCode, Long duration, boolean success, String commandName, String type, String target, Map<String, String> properties, Map<String, String> tags, Map<String, Double> metrics, @Nullable String connectionString, @Nullable String instrumentationKey) {
        if (delegate != null) {
            delegate.trackDependency(timestamp, name, id, resultCode, duration, success, commandName, type, target, properties, tags, metrics, connectionString, instrumentationKey);
        }
    }

    public static void trackPageView(@Nullable Date timestamp, String name, URI uri, long totalMillis, Map<String, String> properties, Map<String, String> tags, Map<String, Double> metrics, @Nullable String connectionString, @Nullable String instrumentationKey) {
        if (delegate != null) {
            delegate.trackPageView(timestamp, name, uri, totalMillis, properties, tags, metrics, connectionString, instrumentationKey);
        }
    }

    public static void trackTrace(@Nullable Date timestamp, String message, int severityLevel, Map<String, String> properties, Map<String, String> tags, @Nullable String connectionString, @Nullable String instrumentationKey) {
        if (delegate != null) {
            delegate.trackTrace(timestamp, message, severityLevel, properties, tags, connectionString, instrumentationKey);
        }
    }

    public static void trackRequest(String id, String name, URL url, @Nullable Date timestamp, Long duration, String responseCode, boolean success, String source, Map<String, String> properties, Map<String, String> tags, Map<String, Double> metrics, @Nullable String connectionString, @Nullable String instrumentationKey) {
        if (delegate != null) {
            delegate.trackRequest(id, name, url, timestamp, duration, responseCode, success, source, properties, tags, metrics, connectionString, instrumentationKey);
        }
    }

    public static void trackException(@Nullable Date timestamp, Throwable throwable, int severityLevel, Map<String, String> properties, Map<String, String> tags, Map<String, Double> metrics, @Nullable String connectionString, @Nullable String instrumentationKey) {
        if (delegate != null) {
            delegate.trackException(timestamp, throwable, severityLevel, properties, tags, metrics, connectionString, instrumentationKey);
        }
    }

    public static void trackAvailability(@Nullable Date timestamp, String id, String name, @Nullable Long duration, boolean success, String runLocation, String message, Map<String, String> properties, Map<String, String> tags, Map<String, Double> metrics, @Nullable String connectionString, @Nullable String instrumentationKey) {
        if (delegate != null) {
            delegate.trackAvailability(timestamp, id, name, duration, success, runLocation, message, properties, tags, metrics, connectionString, instrumentationKey);
        }
    }

    public static void flush() {
        if (delegate != null) {
            delegate.flush();
        }
    }

    public static void logErrorOnce(Throwable t) {
        if (delegate != null) {
            delegate.logErrorOnce(t);
        }
    }

    public static boolean shouldSample(String operationId) {
        return delegate != null && delegate.shouldSample(operationId);
    }

    public static long getTotalMilliseconds(long days, int hours, int minutes, int seconds, int milliseconds) {
        return TimeUnit.DAYS.toMillis(days) + TimeUnit.HOURS.toMillis(hours) + TimeUnit.MINUTES.toMillis(minutes) + TimeUnit.SECONDS.toMillis(seconds) + (long)milliseconds;
    }

    public static void copy(@Nullable Map<String, String> source, Map<String, String> target, @Nullable String excludePrefix) {
        if (source == null) {
            return;
        }
        for (Map.Entry<String, String> entry : source.entrySet()) {
            String value;
            String key = entry.getKey();
            if (key == null || key.isEmpty() || excludePrefix != null && key.startsWith(excludePrefix) || target.containsKey(key) || (value = entry.getValue()) == null) continue;
            target.put(key, value);
        }
    }

    public static void onEnter() {
        startNanosHolder.set(System.nanoTime());
    }

    public static void onExit() {
        Long startNanos = startNanosHolder.get();
        if (startNanos == null) {
            System.out.println("Signed jar access (no timing available)");
            Thread.dumpStack();
        } else {
            long durationNanos = System.nanoTime() - startNanos;
            if (durationNanos > TimeUnit.MILLISECONDS.toNanos(1L)) {
                System.out.println("Signed jar access (" + TimeUnit.NANOSECONDS.toMillis(durationNanos) + " milliseconds)");
                Thread.dumpStack();
            }
        }
        startNanosHolder.remove();
    }

    private BytecodeUtil() {
    }

    static {
        startNanosHolder = new ThreadLocal();
    }

    public static interface BytecodeUtilDelegate {
        public void setConnectionString(String var1);

        public void trackEvent(@Nullable Date var1, String var2, Map<String, String> var3, Map<String, String> var4, Map<String, Double> var5, @Nullable String var6, @Nullable String var7);

        public void trackMetric(@Nullable Date var1, String var2, @Nullable String var3, double var4, Integer var6, Double var7, Double var8, @Nullable Double var9, Map<String, String> var10, Map<String, String> var11, @Nullable String var12, @Nullable String var13);

        public void trackDependency(@Nullable Date var1, String var2, String var3, String var4, Long var5, boolean var6, String var7, String var8, String var9, Map<String, String> var10, Map<String, String> var11, Map<String, Double> var12, @Nullable String var13, @Nullable String var14);

        public void trackPageView(@Nullable Date var1, String var2, URI var3, long var4, Map<String, String> var6, Map<String, String> var7, Map<String, Double> var8, @Nullable String var9, @Nullable String var10);

        public void trackTrace(@Nullable Date var1, String var2, int var3, Map<String, String> var4, Map<String, String> var5, @Nullable String var6, @Nullable String var7);

        public void trackRequest(String var1, String var2, URL var3, @Nullable Date var4, Long var5, String var6, boolean var7, String var8, Map<String, String> var9, Map<String, String> var10, Map<String, Double> var11, @Nullable String var12, @Nullable String var13);

        public void trackException(@Nullable Date var1, Throwable var2, int var3, Map<String, String> var4, Map<String, String> var5, Map<String, Double> var6, @Nullable String var7, @Nullable String var8);

        public void trackAvailability(@Nullable Date var1, String var2, String var3, @Nullable Long var4, boolean var5, String var6, String var7, Map<String, String> var8, Map<String, String> var9, Map<String, Double> var10, @Nullable String var11, @Nullable String var12);

        public void flush();

        public void logErrorOnce(Throwable var1);

        public boolean shouldSample(String var1);
    }
}

