/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;

public final class HttpSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private final HttpCommonAttributesGetter<REQUEST, ?> getter;

    public static <REQUEST> SpanNameExtractor<REQUEST> create(HttpCommonAttributesGetter<REQUEST, ?> getter) {
        return new HttpSpanNameExtractor<REQUEST>(getter);
    }

    private HttpSpanNameExtractor(HttpCommonAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public String extract(REQUEST request) {
        String method = this.getter.getMethod(request);
        String route = this.extractRoute(request);
        if (method != null) {
            return route == null ? method : method + " " + route;
        }
        return "HTTP";
    }

    @Nullable
    private String extractRoute(REQUEST request) {
        if (this.getter instanceof HttpServerAttributesGetter) {
            return ((HttpServerAttributesGetter)this.getter).getRoute(request);
        }
        return null;
    }
}

