/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.diagnostics.log;

import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.ApplicationMetadataFactory;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.DiagnosticsHelper;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.PatternLayout;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.spi.ILoggingEvent;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.spi.IThrowableProxy;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.spi.ThrowableProxy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class ApplicationInsightsCsvLayout
extends PatternLayout {
    private static final String PREFIX = "LanguageWorkerConsoleLogMS_APPLICATION_INSIGHTS_LOGS";
    private static final ApplicationMetadataFactory applicationMetadataFactory = DiagnosticsHelper.getMetadataFactory();
    private final String qualifiedSdkVersion;

    public ApplicationInsightsCsvLayout(String qualifiedSdkVersion) {
        this.qualifiedSdkVersion = qualifiedSdkVersion;
    }

    @Override
    @SuppressFBWarnings(value={"ERRMSG"}, justification="Error message is not exposed to an end user of the instrumented application")
    public String doLayout(ILoggingEvent event) {
        String message = event.getFormattedMessage();
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        Throwable throwable = null;
        if (throwableProxy instanceof ThrowableProxy) {
            throwable = ((ThrowableProxy)throwableProxy).getThrowable();
        }
        if (throwable != null) {
            message = message + " ";
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter((Writer)sw, true));
            message = message + sw;
        }
        return "LanguageWorkerConsoleLogMS_APPLICATION_INSIGHTS_LOGS " + event.getTimeStamp() + "," + event.getLevel().toString() + "," + event.getLoggerName() + ",\"" + ApplicationInsightsCsvLayout.formatForCsv(message) + "\"," + applicationMetadataFactory.getSiteName().getValue() + "," + applicationMetadataFactory.getInstrumentationKey().getValue() + "," + this.qualifiedSdkVersion + ",java" + System.getProperty("line.separator");
    }

    private static String formatForCsv(String str) {
        return str.replace("\r\n", " ").replace("\n", " ").replace('\"', '\'');
    }
}

