/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.ForwardedHeaderParser;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpNetworkTransportFilter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.FallbackNamePortGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.InternalNetServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalNetworkAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.url.internal.InternalUrlAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.List;
import java.util.function.Function;

public final class HttpServerAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpServerAttributesGetter<REQUEST, RESPONSE>>
implements SpanKeyProvider {
    private static final boolean PREFER_FORWARDED_URL_SCHEME = ConfigPropertiesUtil.getBoolean("otel.instrumentation.http.prefer-forwarded-url-scheme", false);
    private final InternalUrlAttributesExtractor<REQUEST> internalUrlExtractor;
    private final InternalNetServerAttributesExtractor<REQUEST, RESPONSE> internalNetExtractor;
    private final InternalNetworkAttributesExtractor<REQUEST, RESPONSE> internalNetworkExtractor;
    private final InternalServerAttributesExtractor<REQUEST, RESPONSE> internalServerExtractor;
    private final InternalClientAttributesExtractor<REQUEST, RESPONSE> internalClientExtractor;
    private final Function<Context, String> httpRouteHolderGetter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        return HttpServerAttributesExtractor.builder(httpAttributesGetter, netAttributesGetter).build();
    }

    public static <REQUEST, RESPONSE> HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        return new HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE>(httpAttributesGetter, netAttributesGetter);
    }

    HttpServerAttributesExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders) {
        this(httpAttributesGetter, netAttributesGetter, capturedRequestHeaders, capturedResponseHeaders, HttpRouteHolder::getRoute);
    }

    HttpServerAttributesExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders, Function<Context, String> httpRouteHolderGetter) {
        super(httpAttributesGetter, capturedRequestHeaders, capturedResponseHeaders);
        HttpCommonAttributesExtractor.HttpNetNamePortGetter<REQUEST> namePortGetter = new HttpCommonAttributesExtractor.HttpNetNamePortGetter<REQUEST>(httpAttributesGetter);
        this.internalUrlExtractor = new InternalUrlAttributesExtractor<Object>(httpAttributesGetter, this::forwardedProto, SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
        this.internalNetExtractor = new InternalNetServerAttributesExtractor<REQUEST, RESPONSE>(netAttributesGetter, namePortGetter, SemconvStability.emitOldHttpSemconv());
        this.internalNetworkExtractor = new InternalNetworkAttributesExtractor<REQUEST, RESPONSE>(netAttributesGetter, HttpNetworkTransportFilter.INSTANCE, SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
        this.internalServerExtractor = new InternalServerAttributesExtractor<Object, RESPONSE>(netAttributesGetter, this::shouldCaptureServerPort, namePortGetter, SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv(), InternalServerAttributesExtractor.Mode.HOST);
        this.internalClientExtractor = new InternalClientAttributesExtractor<REQUEST, RESPONSE>(netAttributesGetter, new ClientAddressGetter(httpAttributesGetter), SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
        this.httpRouteHolderGetter = httpRouteHolderGetter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        this.internalUrlExtractor.onStart(attributes, request);
        this.internalNetExtractor.onStart(attributes, request);
        this.internalServerExtractor.onStart(attributes, request);
        this.internalClientExtractor.onStart(attributes, request);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_ROUTE, ((HttpServerAttributesGetter)this.getter).getHttpRoute(request));
    }

    private boolean shouldCaptureServerPort(int port, REQUEST request) {
        String scheme = ((HttpServerAttributesGetter)this.getter).getUrlScheme(request);
        if (scheme == null) {
            return true;
        }
        return (!scheme.equals("http") || port != 80) && (!scheme.equals("https") || port != 443);
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, context, request, response, error);
        this.internalNetworkExtractor.onEnd(attributes, request, response);
        this.internalServerExtractor.onEnd(attributes, request, response);
        this.internalClientExtractor.onEnd(attributes, request, response);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_ROUTE, this.httpRouteHolderGetter.apply(context));
    }

    @Nullable
    private String forwardedProto(REQUEST request) {
        if (!PREFER_FORWARDED_URL_SCHEME) {
            return null;
        }
        String forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).getHttpRequestHeader(request, "forwarded"));
        if (forwarded != null && (forwarded = ForwardedHeaderParser.extractProtoFromForwardedHeader(forwarded)) != null) {
            return forwarded;
        }
        forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).getHttpRequestHeader(request, "x-forwarded-proto"));
        if (forwarded != null) {
            return ForwardedHeaderParser.extractProtoFromForwardedProtoHeader(forwarded);
        }
        return null;
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.HTTP_SERVER;
    }

    private static final class ClientAddressGetter<REQUEST>
    implements FallbackNamePortGetter<REQUEST> {
        private final HttpServerAttributesGetter<REQUEST, ?> getter;

        private ClientAddressGetter(HttpServerAttributesGetter<REQUEST, ?> getter) {
            this.getter = getter;
        }

        @Override
        @Nullable
        public String name(REQUEST request) {
            String forwarded = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "forwarded"));
            if (forwarded != null && (forwarded = ForwardedHeaderParser.extractClientIpFromForwardedHeader(forwarded)) != null) {
                return forwarded;
            }
            forwarded = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "x-forwarded-for"));
            if (forwarded != null) {
                return ForwardedHeaderParser.extractClientIpFromForwardedForHeader(forwarded);
            }
            return null;
        }

        @Override
        @Nullable
        public Integer port(REQUEST request) {
            return null;
        }
    }
}

