/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.FallbackNamePortGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;

public final class InternalNetClientAttributesExtractor<REQUEST, RESPONSE> {
    private final NetClientAttributesGetter<REQUEST, RESPONSE> getter;
    private final FallbackNamePortGetter<REQUEST> fallbackNamePortGetter;
    private final boolean emitOldHttpAttributes;

    public InternalNetClientAttributesExtractor(NetClientAttributesGetter<REQUEST, RESPONSE> getter, FallbackNamePortGetter<REQUEST> fallbackNamePortGetter, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.fallbackNamePortGetter = fallbackNamePortGetter;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        if (this.emitOldHttpAttributes) {
            String sockFamily;
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_TRANSPORT, this.getter.getTransport(request, response));
            String peerName = this.extractPeerName(request);
            String sockPeerAddr = this.getter.getServerSocketAddress(request, response);
            if (sockPeerAddr != null && !sockPeerAddr.equals(peerName) && (sockFamily = this.getter.getSockFamily(request, response)) != null && !"inet".equals(sockFamily)) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_FAMILY, sockFamily);
            }
        }
    }

    private String extractPeerName(REQUEST request) {
        String peerName = this.getter.getServerAddress(request);
        if (peerName == null) {
            peerName = this.fallbackNamePortGetter.name(request);
        }
        return peerName;
    }
}

