/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

public final class ContextPropagationDebug {
    private static final PatchLogger logger = PatchLogger.getLogger(ContextPropagationDebug.class.getName());
    private static final ContextKey<ContextPropagationDebug> THREAD_PROPAGATION_LOCATIONS = ContextKey.named("thread-propagation-locations");
    private static final boolean THREAD_PROPAGATION_DEBUGGER;
    private static final boolean FAIL_ON_CONTEXT_LEAK;
    private final Context sourceContext;
    private final List<Propagation> locations;
    private Context wrappedContext;

    private ContextPropagationDebug(Context sourceContext) {
        this.sourceContext = sourceContext;
        this.locations = new CopyOnWriteArrayList<Propagation>();
    }

    public static boolean isThreadPropagationDebuggerEnabled() {
        return THREAD_PROPAGATION_DEBUGGER;
    }

    public static Context appendLocations(Context context, StackTraceElement[] locations, Object carrier) {
        ContextPropagationDebug propagationDebug = ContextPropagationDebug.getPropagations(context);
        if (propagationDebug == null) {
            propagationDebug = new ContextPropagationDebug(context);
            propagationDebug.wrappedContext = context = context.with(THREAD_PROPAGATION_LOCATIONS, propagationDebug);
        }
        propagationDebug.locations.add(0, new Propagation(carrier.getClass().getName(), locations));
        return context;
    }

    public static void debugContextLeakIfEnabled() {
        if (!ContextPropagationDebug.isThreadPropagationDebuggerEnabled()) {
            return;
        }
        Context current = Context.current();
        if (current != Context.root()) {
            logger.warning("Unexpected non-root current context found when extracting remote context!");
            Span currentSpan = Span.fromContextOrNull(current);
            if (currentSpan != null) {
                logger.log(Level.WARNING, "It contains this span: {0}", currentSpan);
            }
            ContextPropagationDebug.debugContextPropagation(current);
            if (FAIL_ON_CONTEXT_LEAK) {
                throw new IllegalStateException("Context leak detected");
            }
        }
    }

    public static Context unwrap(Context context) {
        if (context == null || !ContextPropagationDebug.isThreadPropagationDebuggerEnabled()) {
            return context;
        }
        ContextPropagationDebug propagationDebug = ContextPropagationDebug.getPropagations(context);
        if (propagationDebug == null) {
            return context;
        }
        return propagationDebug.wrappedContext == context ? propagationDebug.sourceContext : context;
    }

    @Nullable
    private static ContextPropagationDebug getPropagations(Context context) {
        return context.get(THREAD_PROPAGATION_LOCATIONS);
    }

    private static void debugContextPropagation(Context context) {
        ContextPropagationDebug propagationDebug = ContextPropagationDebug.getPropagations(context);
        if (propagationDebug != null) {
            List<Propagation> propagations = propagationDebug.locations;
            StringBuilder sb = new StringBuilder();
            Iterator<Propagation> i = propagations.iterator();
            while (i.hasNext()) {
                Propagation entry = i.next();
                sb.append("\ncarrier of type: ").append(entry.carrierClassName);
                for (StackTraceElement ste : entry.location) {
                    sb.append("\n    ");
                    sb.append(ste);
                }
                if (!i.hasNext()) continue;
                sb.append("\nwhich was propagated from:");
            }
            logger.log(Level.WARNING, "a context leak was detected. it was propagated from: {0}", sb);
        }
    }

    static {
        boolean agentDebugEnabled = ConfigPropertiesUtil.getBoolean("otel.javaagent.debug", false);
        THREAD_PROPAGATION_DEBUGGER = ConfigPropertiesUtil.getBoolean("otel.javaagent.experimental.thread-propagation-debugger.enabled", agentDebugEnabled);
        FAIL_ON_CONTEXT_LEAK = ConfigPropertiesUtil.getBoolean("otel.javaagent.testing.fail-on-context-leak", false);
    }

    private static class Propagation {
        public final String carrierClassName;
        public final StackTraceElement[] location;

        public Propagation(String carrierClassName, StackTraceElement[] location) {
            this.carrierClassName = carrierClassName;
            this.location = location;
        }
    }
}

