/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanSuppressor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanSuppressors;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Set;

enum SpanSuppressionStrategy {
    NONE{

        @Override
        SpanSuppressor create(Set<SpanKey> spanKeys) {
            return SpanSuppressors.Noop.INSTANCE;
        }
    }
    ,
    SPAN_KIND{
        private final SpanSuppressor strategy;
        {
            EnumMap<SpanKind, SpanSuppressor> delegates = new EnumMap<SpanKind, SpanSuppressor>(SpanKind.class);
            delegates.put(SpanKind.SERVER, new SpanSuppressors.BySpanKey(Collections.singleton(SpanKey.KIND_SERVER)));
            delegates.put(SpanKind.CLIENT, new SpanSuppressors.BySpanKey(Collections.singleton(SpanKey.KIND_CLIENT)));
            delegates.put(SpanKind.CONSUMER, new SpanSuppressors.BySpanKey(Collections.singleton(SpanKey.KIND_CONSUMER)));
            delegates.put(SpanKind.PRODUCER, new SpanSuppressors.BySpanKey(Collections.singleton(SpanKey.KIND_PRODUCER)));
            this.strategy = new SpanSuppressors.DelegateBySpanKind(delegates);
        }

        @Override
        SpanSuppressor create(Set<SpanKey> spanKeys) {
            return this.strategy;
        }
    }
    ,
    SEMCONV{

        @Override
        SpanSuppressor create(Set<SpanKey> spanKeys) {
            if (spanKeys.isEmpty()) {
                return SpanSuppressors.Noop.INSTANCE;
            }
            return new SpanSuppressors.BySpanKey(spanKeys);
        }
    };


    abstract SpanSuppressor create(Set<SpanKey> var1);

    static SpanSuppressionStrategy fromConfig(@Nullable String value) {
        if (value == null) {
            value = "semconv";
        }
        switch (value.toLowerCase(Locale.ROOT)) {
            case "none": {
                return NONE;
            }
            case "span-kind": {
                return SPAN_KIND;
            }
        }
        return SEMCONV;
    }
}

