/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging.CapturedMessageHeadersUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.SemanticAttributes;
import java.util.List;

public final class MessagingAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    static final String TEMP_DESTINATION_NAME = "(temporary)";
    private final MessagingAttributesGetter<REQUEST, RESPONSE> getter;
    private final MessageOperation operation;
    private final List<String> capturedHeaders;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        return MessagingAttributesExtractor.builder(getter, operation).build();
    }

    public static <REQUEST, RESPONSE> MessagingAttributesExtractorBuilder<REQUEST, RESPONSE> builder(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        return new MessagingAttributesExtractorBuilder<REQUEST, RESPONSE>(getter, operation);
    }

    MessagingAttributesExtractor(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation, List<String> capturedHeaders) {
        this.getter = getter;
        this.operation = operation;
        this.capturedHeaders = CapturedMessageHeadersUtil.lowercase(capturedHeaders);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.MESSAGING_SYSTEM, this.getter.getSystem(request));
        boolean isTemporaryDestination = this.getter.isTemporaryDestination(request);
        if (isTemporaryDestination) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.MESSAGING_DESTINATION_TEMPORARY, true);
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.MESSAGING_DESTINATION_NAME, TEMP_DESTINATION_NAME);
        } else {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.MESSAGING_DESTINATION_NAME, this.getter.getDestination(request));
        }
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.MESSAGING_MESSAGE_CONVERSATION_ID, this.getter.getConversationId(request));
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES, this.getter.getMessagePayloadSize(request));
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.MESSAGING_MESSAGE_PAYLOAD_COMPRESSED_SIZE_BYTES, this.getter.getMessagePayloadCompressedSize(request));
        if (this.operation == MessageOperation.RECEIVE || this.operation == MessageOperation.PROCESS) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.MESSAGING_OPERATION, this.operation.operationName());
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.MESSAGING_MESSAGE_ID, this.getter.getMessageId(request, response));
        for (String name : this.capturedHeaders) {
            List<String> values = this.getter.getMessageHeader(request, name);
            if (values.isEmpty()) continue;
            AttributesExtractorUtil.internalSet(attributes, CapturedMessageHeadersUtil.attributeKey(name), values);
        }
    }

    @Override
    public SpanKey internalGetSpanKey() {
        switch (this.operation) {
            case PUBLISH: {
                return SpanKey.PRODUCER;
            }
            case RECEIVE: {
                return SpanKey.CONSUMER_RECEIVE;
            }
            case PROCESS: {
                return SpanKey.CONSUMER_PROCESS;
            }
        }
        throw new IllegalStateException("Can't possibly happen");
    }
}

