/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.NetworkAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.NetworkTransportFilter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.SemanticAttributes;
import java.util.Locale;

public final class InternalNetworkAttributesExtractor<REQUEST, RESPONSE> {
    private final NetworkAttributesGetter<REQUEST, RESPONSE> getter;
    private final NetworkTransportFilter networkTransportFilter;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;

    public InternalNetworkAttributesExtractor(NetworkAttributesGetter<REQUEST, RESPONSE> getter, NetworkTransportFilter networkTransportFilter, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.networkTransportFilter = networkTransportFilter;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        String protocolName = InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkProtocolName(request, response));
        String protocolVersion = InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkProtocolVersion(request, response));
        if (this.emitStableUrlAttributes) {
            String transport = InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkTransport(request, response));
            if (this.networkTransportFilter.shouldAddNetworkTransport(protocolName, protocolVersion, transport)) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NETWORK_TRANSPORT, transport);
            }
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NETWORK_TYPE, InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkType(request, response)));
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NETWORK_PROTOCOL_NAME, protocolName);
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NETWORK_PROTOCOL_VERSION, protocolVersion);
        }
        if (this.emitOldHttpAttributes) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_PROTOCOL_NAME, protocolName);
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_PROTOCOL_VERSION, protocolVersion);
        }
    }

    @Nullable
    private static String lowercase(@Nullable String str) {
        return str == null ? null : str.toLowerCase(Locale.ROOT);
    }
}

