/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import java.util.function.Predicate;

public final class UrlParser {
    @Nullable
    public static String getHost(String url) {
        int startIndex = UrlParser.getHostStartIndex(url);
        if (startIndex == -1) {
            return null;
        }
        int endIndexExclusive = UrlParser.getHostEndIndexExclusive(url, startIndex);
        if (endIndexExclusive == startIndex) {
            return null;
        }
        return url.substring(startIndex, endIndexExclusive);
    }

    @Nullable
    public static Integer getPort(String url) {
        int hostStartIndex = UrlParser.getHostStartIndex(url);
        if (hostStartIndex == -1) {
            return null;
        }
        int hostEndIndexExclusive = UrlParser.getHostEndIndexExclusive(url, hostStartIndex);
        if (hostEndIndexExclusive == hostStartIndex) {
            return null;
        }
        if (hostEndIndexExclusive < url.length() && url.charAt(hostEndIndexExclusive) != ':') {
            return null;
        }
        int portStartIndex = hostEndIndexExclusive + 1;
        int portEndIndexExclusive = UrlParser.getPortEndIndexExclusive(url, portStartIndex);
        if (portEndIndexExclusive == portStartIndex) {
            return null;
        }
        return UrlParser.safeParse(url.substring(portStartIndex, portEndIndexExclusive));
    }

    @Nullable
    public static String getPath(String url) {
        int hostStartIndex = UrlParser.getHostStartIndex(url);
        if (hostStartIndex == -1) {
            return null;
        }
        int hostEndIndexExclusive = UrlParser.getHostEndIndexExclusive(url, hostStartIndex);
        if (hostEndIndexExclusive == hostStartIndex) {
            return null;
        }
        int pathStartIndex = url.indexOf(47, hostEndIndexExclusive);
        if (pathStartIndex == -1) {
            return null;
        }
        int pathEndIndexExclusive = UrlParser.getPathEndIndexExclusive(url, pathStartIndex);
        if (pathEndIndexExclusive == pathStartIndex) {
            return null;
        }
        return url.substring(pathStartIndex, pathEndIndexExclusive);
    }

    private static int getHostStartIndex(String url) {
        int schemeEndIndex = url.indexOf(58);
        if (schemeEndIndex == -1) {
            return -1;
        }
        int len = url.length();
        if (len <= schemeEndIndex + 2 || url.charAt(schemeEndIndex + 1) != '/' || url.charAt(schemeEndIndex + 2) != '/') {
            return -1;
        }
        return schemeEndIndex + 3;
    }

    private static int getHostEndIndexExclusive(String url, int startIndex) {
        return UrlParser.getEndIndexExclusive(url, startIndex, c -> c.charValue() == ':' || c.charValue() == '/' || c.charValue() == '?' || c.charValue() == '#');
    }

    private static int getPortEndIndexExclusive(String url, int startIndex) {
        return UrlParser.getEndIndexExclusive(url, startIndex, c -> c.charValue() == '/' || c.charValue() == '?' || c.charValue() == '#');
    }

    private static int getPathEndIndexExclusive(String url, int startIndex) {
        return UrlParser.getEndIndexExclusive(url, startIndex, c -> c.charValue() == '?' || c.charValue() == '#');
    }

    private static int getEndIndexExclusive(String url, int startIndex, Predicate<Character> predicate) {
        char c;
        int index;
        int len = url.length();
        for (index = startIndex; index < len && !predicate.test(Character.valueOf(c = url.charAt(index))); ++index) {
        }
        return index;
    }

    @Nullable
    private static Integer safeParse(String port) {
        try {
            return Integer.valueOf(port);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private UrlParser() {
    }
}

