/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class DllFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DllFileUtils.class);
    public static final String AI_BASE_FOLDER = "AISDK";
    public static final String AI_NATIVE_FOLDER = "native";
    private static final List<String> CANDIDATE_USERNAME_ENVIRONMENT_VARIABLES = Collections.unmodifiableList(Arrays.asList("USER", "LOGNAME", "USERNAME"));

    private DllFileUtils() {
    }

    @SuppressFBWarnings(value={"SECPTI"}, justification="The constructed file path cannot be controlled by an end user of the instrumented application")
    public static File buildDllLocalPath(@Nullable String versionDirectory) {
        File dllPath = DllFileUtils.getTempDir();
        dllPath = new File(dllPath, AI_BASE_FOLDER);
        dllPath = new File(dllPath, AI_NATIVE_FOLDER);
        dllPath = versionDirectory == null || versionDirectory.isEmpty() ? new File(dllPath, "unknown-version") : new File(dllPath, versionDirectory);
        if (!dllPath.exists()) {
            dllPath.mkdirs();
        }
        if (!(dllPath.exists() && dllPath.canRead() && dllPath.canWrite())) {
            throw new IllegalStateException("Failed to create a read/write folder for the native dll.");
        }
        LOGGER.trace("{} folder exists", (Object)dllPath);
        return dllPath;
    }

    public static void extractToLocalFolder(File dllOnDisk, String libraryToLoad) throws IOException {
        ClassLoader classLoader = DllFileUtils.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try (InputStream in = classLoader.getResourceAsStream(libraryToLoad);){
            if (in == null) {
                throw new IllegalStateException(String.format("Failed to find '%s' in jar", libraryToLoad));
            }
            byte[] buffer = new byte[8192];
            try (FileOutputStream out = new FileOutputStream(dllOnDisk, false);){
                int bytesRead;
                if (dllOnDisk.exists()) {
                    if (dllOnDisk.isDirectory()) {
                        throw new IOException("Cannot extract dll: " + dllOnDisk.getAbsolutePath() + " exists as a directory");
                    }
                    if (!dllOnDisk.canWrite()) {
                        throw new IOException("Cannote extract dll: " + dllOnDisk.getAbsolutePath() + " is not writeable.");
                    }
                }
                while ((bytesRead = in.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                }
            }
        }
        LOGGER.debug("Successfully extracted '{}' to local folder", (Object)libraryToLoad);
    }

    private static File getTempDir() {
        String currentUserName;
        String tempDirectory = System.getProperty("java.io.tmpdir");
        File result = DllFileUtils.getTempDir(tempDirectory, currentUserName = DllFileUtils.determineCurrentUserName());
        if (!result.isDirectory()) {
            result.mkdirs();
        }
        return result;
    }

    @SuppressFBWarnings(value={"SECPTI"}, justification="The constructed file path cannot be controlled by an end user of the instrumented application")
    private static File getTempDir(String initialValue, String userName) {
        String tempDirectory = initialValue;
        if ("/tmp".contentEquals(tempDirectory)) {
            File candidate = new File(tempDirectory, userName);
            tempDirectory = candidate.getAbsolutePath();
        }
        return new File(tempDirectory);
    }

    private static String determineCurrentUserName() {
        String userName = System.getProperty("user.name");
        if (userName != null && !userName.isEmpty()) {
            String candidate;
            Iterator<String> iterator = CANDIDATE_USERNAME_ENVIRONMENT_VARIABLES.iterator();
            while (iterator.hasNext() && ((userName = System.getenv(candidate = iterator.next())) == null || !userName.isEmpty())) {
            }
        }
        if (userName == null || userName.isEmpty()) {
            userName = "unknown";
        }
        return userName;
    }
}

