/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.logging.Level;

public class InternalNetServerAttributesExtractor {
    private static final PatchLogger logger = PatchLogger.getLogger(InternalNetServerAttributesExtractor.class.getName());

    public static <REQUEST> void onStart(NetServerAttributesGetter<REQUEST> getter, AttributesBuilder attributes, REQUEST request, @Nullable String hostHeader) {
        String sockFamily;
        String sockHostAddr;
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_TRANSPORT, getter.transport(request));
        boolean setSockFamily = false;
        String sockPeerAddr = getter.sockPeerAddr(request);
        if (sockPeerAddr != null) {
            setSockFamily = true;
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_PEER_ADDR, sockPeerAddr);
            Integer sockPeerPort = getter.sockPeerPort(request);
            if (sockPeerPort != null && sockPeerPort > 0) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_PEER_PORT, Long.valueOf(sockPeerPort.intValue()));
            }
        }
        String hostName = getter.hostName(request);
        Integer hostPort = getter.hostPort(request);
        int hostHeaderSeparator = -1;
        if (hostHeader != null) {
            hostHeaderSeparator = hostHeader.indexOf(58);
        }
        if (hostName == null && hostHeader != null) {
            String string = hostName = hostHeaderSeparator == -1 ? hostHeader : hostHeader.substring(0, hostHeaderSeparator);
        }
        if (hostPort == null && hostHeader != null && hostHeaderSeparator != -1) {
            try {
                hostPort = Integer.parseInt(hostHeader.substring(hostHeaderSeparator + 1));
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (hostName != null) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_HOST_NAME, hostName);
            if (hostPort != null && hostPort > 0) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_HOST_PORT, Long.valueOf(hostPort.intValue()));
            }
        }
        if ((sockHostAddr = getter.sockHostAddr(request)) != null && !sockHostAddr.equals(hostName)) {
            setSockFamily = true;
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_HOST_ADDR, sockHostAddr);
            Integer sockHostPort = getter.sockHostPort(request);
            if (sockHostPort != null && sockHostPort > 0 && !sockHostPort.equals(hostPort)) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_HOST_PORT, Long.valueOf(sockHostPort.intValue()));
            }
        }
        if (setSockFamily && (sockFamily = getter.sockFamily(request)) != null && !"inet".equals(sockFamily)) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_FAMILY, sockFamily);
        }
    }

    private InternalNetServerAttributesExtractor() {
    }
}

