/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.bootstrap.AgentStarter;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;

public final class AgentInitializer {
    @Nullable
    private static ClassLoader agentClassLoader = null;
    @Nullable
    private static AgentStarter agentStarter = null;

    public static void initialize(Instrumentation inst, File javaagentFile, boolean fromPremain) throws Exception {
        if (agentClassLoader != null) {
            return;
        }
        agentClassLoader = AgentInitializer.createAgentClassLoader("inst", javaagentFile);
        agentStarter = AgentInitializer.createAgentStarter(agentClassLoader, inst, javaagentFile);
        if (!fromPremain || !AgentInitializer.delayAgentStart()) {
            agentStarter.start();
        }
    }

    private static boolean isEarlyOracle18() {
        String vmName = System.getProperty("java.vm.name");
        if (!vmName.contains("HotSpot") && !vmName.contains("OpenJDK")) {
            return false;
        }
        String javaVersion = System.getProperty("java.version");
        if (!javaVersion.startsWith("1.8")) {
            return false;
        }
        int index = javaVersion.indexOf(95);
        if (index == -1) {
            return false;
        }
        String minorVersion = javaVersion.substring(index + 1);
        try {
            int version = Integer.parseInt(minorVersion);
            if (version >= 40) {
                return false;
            }
        }
        catch (NumberFormatException exception) {
            return false;
        }
        return true;
    }

    private static boolean delayAgentStart() {
        if (!AgentInitializer.isEarlyOracle18()) {
            return false;
        }
        return agentStarter.delayStart();
    }

    public static void delayedStartHook() {
        agentStarter.start();
    }

    public static ClassLoader getExtensionsClassLoader() {
        return agentStarter != null ? agentStarter.getExtensionClassLoader() : null;
    }

    private static ClassLoader createAgentClassLoader(String innerJarFilename, File javaagentFile) {
        return new AgentClassLoader(javaagentFile, innerJarFilename);
    }

    private static AgentStarter createAgentStarter(ClassLoader agentClassLoader, Instrumentation instrumentation, File javaagentFile) throws Exception {
        Class<?> starterClass = agentClassLoader.loadClass("io.opentelemetry.javaagent.tooling.AgentStarterImpl");
        Constructor<?> constructor = starterClass.getDeclaredConstructor(Instrumentation.class, File.class);
        return (AgentStarter)constructor.newInstance(instrumentation, javaagentFile);
    }

    private AgentInitializer() {
    }
}

