/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import java.util.function.Predicate;

public final class InstrumentedTaskClasses {
    private static final PatchLogger logger = PatchLogger.getLogger(InstrumentedTaskClasses.class.getName());
    private static final String AGENT_CLASSLOADER_NAME = "io.opentelemetry.javaagent.bootstrap.AgentClassLoader";
    private static final ClassValue<Boolean> INSTRUMENTED_TASK_CLASS = new ClassValue<Boolean>(){

        @Override
        protected Boolean computeValue(Class<?> taskClass) {
            if (ignoredTaskClassesPredicate.test(taskClass.getName())) {
                return false;
            }
            ClassLoader taskClassLoader = taskClass.getClassLoader();
            if (taskClassLoader != null && taskClassLoader.getClass().getName().equals(InstrumentedTaskClasses.AGENT_CLASSLOADER_NAME)) {
                return false;
            }
            return true;
        }
    };
    private static volatile Predicate<String> ignoredTaskClassesPredicate;

    public static void setIgnoredTaskClassesPredicate(Predicate<String> ignoredTasksTriePredicate) {
        if (ignoredTaskClassesPredicate != null) {
            logger.warning("Ignored task classes were already set earlier; returning.");
            return;
        }
        ignoredTaskClassesPredicate = ignoredTasksTriePredicate;
    }

    public static boolean canInstrumentTaskClass(Class<?> taskClass) {
        return INSTRUMENTED_TASK_CLASS.get(taskClass);
    }

    private InstrumentedTaskClasses() {
    }
}

