/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.AutoValue_HttpClientMetrics_State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.TemporaryMetricsView;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class HttpClientMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_CLIENT_REQUEST_METRICS_STATE = ContextKey.named("http-client-request-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(HttpClientMetrics.class.getName());
    private final DoubleHistogram duration;
    private final LongHistogram requestSize;
    private final LongHistogram responseSize;

    public static OperationMetrics get() {
        return HttpClientMetrics::new;
    }

    private HttpClientMetrics(Meter meter) {
        this.duration = meter.histogramBuilder("http.client.duration").setUnit("ms").setDescription("The duration of the outbound HTTP request").build();
        this.requestSize = meter.histogramBuilder("http.client.request.size").setUnit("By").setDescription("The size of HTTP request messages").ofLongs().build();
        this.responseSize = meter.histogramBuilder("http.client.response.size").setUnit("By").setDescription("The size of HTTP response messages").ofLongs().build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(HTTP_CLIENT_REQUEST_METRICS_STATE, new AutoValue_HttpClientMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long responseLength;
        State state = context.get(HTTP_CLIENT_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        Attributes durationAndSizeAttributes = TemporaryMetricsView.applyClientDurationAndSizeView(state.startAttributes(), endAttributes);
        this.duration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, durationAndSizeAttributes, context);
        Long requestLength = HttpClientMetrics.getAttribute(SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, endAttributes, state.startAttributes());
        if (requestLength != null) {
            this.requestSize.record(requestLength, durationAndSizeAttributes);
        }
        if ((responseLength = HttpClientMetrics.getAttribute(SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH, endAttributes, state.startAttributes())) != null) {
            this.responseSize.record(responseLength, durationAndSizeAttributes);
        }
    }

    @Nullable
    private static <T> T getAttribute(AttributeKey<T> key, Attributes ... attributesList) {
        for (Attributes attributes : attributesList) {
            T value = attributes.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

