/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.ForwardedHeaderParser;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.InternalNetServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.List;
import java.util.function.Function;

public final class HttpServerAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpServerAttributesGetter<REQUEST, RESPONSE>>
implements SpanKeyProvider {
    private final InternalNetServerAttributesExtractor<REQUEST> internalNetExtractor;
    private final Function<Context, String> httpRouteHolderGetter;

    public static <REQUEST, RESPONSE> HttpServerAttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST> netAttributesGetter) {
        return HttpServerAttributesExtractor.builder(httpAttributesGetter, netAttributesGetter).build();
    }

    public static <REQUEST, RESPONSE> HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST> netAttributesGetter) {
        return new HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE>(httpAttributesGetter, netAttributesGetter);
    }

    HttpServerAttributesExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST> netAttributesGetter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders) {
        this(httpAttributesGetter, netAttributesGetter, capturedRequestHeaders, capturedResponseHeaders, HttpRouteHolder::getRoute);
    }

    HttpServerAttributesExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST> netAttributesGetter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders, Function<Context, String> httpRouteHolderGetter) {
        super(httpAttributesGetter, capturedRequestHeaders, capturedResponseHeaders);
        this.internalNetExtractor = new InternalNetServerAttributesExtractor<Object>(netAttributesGetter, this::shouldCaptureHostPort, new HttpCommonAttributesExtractor.HttpNetNamePortGetter<REQUEST>(httpAttributesGetter));
        this.httpRouteHolderGetter = httpRouteHolderGetter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_FLAVOR, ((HttpServerAttributesGetter)this.getter).flavor(request));
        String forwardedProto = this.forwardedProto(request);
        String value = forwardedProto != null ? forwardedProto : ((HttpServerAttributesGetter)this.getter).scheme(request);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_SCHEME, value);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_TARGET, ((HttpServerAttributesGetter)this.getter).target(request));
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_ROUTE, ((HttpServerAttributesGetter)this.getter).route(request));
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_CLIENT_IP, this.clientIp(request));
        this.internalNetExtractor.onStart(attributes, request);
    }

    private boolean shouldCaptureHostPort(int port, REQUEST request) {
        String scheme = ((HttpServerAttributesGetter)this.getter).scheme(request);
        if (scheme == null) {
            return true;
        }
        return (!scheme.equals("http") || port != 80) && (!scheme.equals("https") || port != 443);
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, context, request, response, error);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_ROUTE, this.httpRouteHolderGetter.apply(context));
    }

    @Nullable
    private String forwardedProto(REQUEST request) {
        String forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).requestHeader(request, "forwarded"));
        if (forwarded != null && (forwarded = ForwardedHeaderParser.extractProtoFromForwardedHeader(forwarded)) != null) {
            return forwarded;
        }
        forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).requestHeader(request, "x-forwarded-proto"));
        if (forwarded != null) {
            return ForwardedHeaderParser.extractProtoFromForwardedProtoHeader(forwarded);
        }
        return null;
    }

    @Nullable
    private String clientIp(REQUEST request) {
        String forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).requestHeader(request, "forwarded"));
        if (forwarded != null && (forwarded = ForwardedHeaderParser.extractClientIpFromForwardedHeader(forwarded)) != null) {
            return forwarded;
        }
        forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).requestHeader(request, "x-forwarded-for"));
        if (forwarded != null) {
            return ForwardedHeaderParser.extractClientIpFromForwardedForHeader(forwarded);
        }
        return null;
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.HTTP_SERVER;
    }
}

