/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import com.microsoft.applicationinsights.agent.shadow.javax.annotation.concurrent.ThreadSafe;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.ValidationUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.concurrent.TimeUnit;

@ThreadSafe
final class DefaultTracer
implements Tracer {
    private static final Tracer INSTANCE = new DefaultTracer();

    static Tracer getInstance() {
        return INSTANCE;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        return NoopSpanBuilder.create();
    }

    private DefaultTracer() {
    }

    private static final class NoopSpanBuilder
    implements SpanBuilder {
        @Nullable
        private SpanContext spanContext;

        static NoopSpanBuilder create() {
            return new NoopSpanBuilder();
        }

        @Override
        public Span startSpan() {
            if (this.spanContext == null) {
                this.spanContext = Span.current().getSpanContext();
            }
            return Span.wrap(this.spanContext);
        }

        @Override
        public NoopSpanBuilder setParent(Context context) {
            if (context == null) {
                ValidationUtil.log("context is null");
                return this;
            }
            this.spanContext = Span.fromContext(context).getSpanContext();
            return this;
        }

        @Override
        public NoopSpanBuilder setNoParent() {
            this.spanContext = SpanContext.getInvalid();
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext) {
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, String value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, long value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, double value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, boolean value) {
            return this;
        }

        @Override
        public <T> NoopSpanBuilder setAttribute(AttributeKey<T> key, T value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAllAttributes(Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setSpanKind(SpanKind spanKind) {
            return this;
        }

        @Override
        public NoopSpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
            return this;
        }

        private NoopSpanBuilder() {
        }
    }
}

