/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.code;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.code.CodeAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.CodeAttributes;

public final class CodeAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private static final AttributeKey<String> CODE_NAMESPACE = AttributeKey.stringKey("code.namespace");
    private static final AttributeKey<String> CODE_FUNCTION = AttributeKey.stringKey("code.function");
    private final CodeAttributesGetter<REQUEST> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(CodeAttributesGetter<REQUEST> getter) {
        return new CodeAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private CodeAttributesExtractor(CodeAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String methodName;
        StringBuilder sb = new StringBuilder();
        Class<?> cls = this.getter.getCodeClass(request);
        if (cls != null) {
            sb.append(cls.getName());
            if (SemconvStability.isEmitOldCodeSemconv()) {
                AttributesExtractorUtil.internalSet(attributes, CODE_NAMESPACE, cls.getName());
            }
        }
        if ((methodName = this.getter.getMethodName(request)) != null) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(methodName);
            if (SemconvStability.isEmitOldCodeSemconv()) {
                AttributesExtractorUtil.internalSet(attributes, CODE_FUNCTION, methodName);
            }
        }
        if (SemconvStability.isEmitStableCodeSemconv() && sb.length() > 0) {
            AttributesExtractorUtil.internalSet(attributes, CodeAttributes.CODE_FUNCTION_NAME, sb.toString());
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

