/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.common;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.common.ApplicationInsightsEvent;
import com.microsoft.applicationinsights.common.TelemetryClientProxy;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.telemetry.ExceptionTelemetry;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.telemetry.TraceTelemetry;
import java.util.Map;

public class LogTelemetryClientProxy
implements TelemetryClientProxy {
    private boolean isInitialized = false;
    private TelemetryClient telemetryClient;

    public LogTelemetryClientProxy(TelemetryClient telemetryClient, String instrumentationKey) {
        try {
            this.telemetryClient = telemetryClient;
            if (!LocalStringsUtils.isNullOrEmpty((String)instrumentationKey)) {
                this.telemetryClient.getContext().setInstrumentationKey(instrumentationKey);
            }
            this.isInitialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LogTelemetryClientProxy(String instrumentationKey) {
        this(new TelemetryClient(), instrumentationKey);
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void sendEvent(ApplicationInsightsEvent event) {
        String formattedMessage = event.getMessage();
        ExceptionTelemetry telemetry = event.isException() ? new ExceptionTelemetry(event.getException()) : new TraceTelemetry(formattedMessage);
        Map<String, String> customParameters = event.getCustomParameters();
        telemetry.getContext().getProperties().putAll(customParameters);
        this.telemetryClient.track((Telemetry)telemetry);
    }

    @Override
    public TelemetryClient getTelemetryClient() {
        return this.telemetryClient;
    }
}

