/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.log4j.v2;

import com.microsoft.applicationinsights.common.LogTelemetryClientProxy;
import com.microsoft.applicationinsights.common.TelemetryClientProxy;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.log4j.v2.ApplicationInsightsLogEvent;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="ApplicationInsightsAppender", category="Core", elementType="appender")
public class ApplicationInsightsAppender
extends AbstractAppender {
    private boolean isInitialized = false;
    private TelemetryClientProxy telemetryClientProxy;

    protected ApplicationInsightsAppender(String name, String instrumentationKey) {
        super(name, null, null);
        try {
            this.telemetryClientProxy = new LogTelemetryClientProxy(instrumentationKey);
            this.isInitialized = true;
        }
        catch (Exception e) {
            this.isInitialized = false;
            InternalLogger.INSTANCE.log("Failed to initialize appender with exception: %s.", new Object[]{e.getMessage()});
        }
    }

    public LogTelemetryClientProxy getTelemetryClientProxy() {
        return (LogTelemetryClientProxy)this.telemetryClientProxy;
    }

    @PluginFactory
    public static ApplicationInsightsAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="instrumentationKey") String instrumentationKey) {
        return new ApplicationInsightsAppender(name, instrumentationKey);
    }

    public void append(LogEvent event) {
        if (!this.isStarted() || !this.isInitialized) {
            return;
        }
        try {
            ApplicationInsightsLogEvent aiEvent = new ApplicationInsightsLogEvent(event);
            this.telemetryClientProxy.sendEvent(aiEvent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        super.start();
    }
}

