/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.log4j.v2;

import com.microsoft.applicationinsights.common.ApplicationInsightsEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;

public class ApplicationInsightsLogEvent
extends ApplicationInsightsEvent {
    private LogEvent logEvent;

    public ApplicationInsightsLogEvent(LogEvent logEvent) {
        this.logEvent = logEvent;
    }

    @Override
    public String getMessage() {
        String message = this.logEvent.getMessage() != null ? this.logEvent.getMessage().getFormattedMessage() : "Log4j Trace";
        return message;
    }

    @Override
    public boolean isException() {
        return this.logEvent.getThrown() != null;
    }

    @Override
    public Exception getException() {
        Exception exception = null;
        if (this.isException()) {
            Throwable throwable = this.logEvent.getThrown();
            exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        }
        return exception;
    }

    @Override
    public Map<String, String> getCustomParameters() {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("SourceType", "Log4j");
        ApplicationInsightsLogEvent.addLogEventProperty("LoggerName", this.logEvent.getLoggerName(), metaData);
        ApplicationInsightsLogEvent.addLogEventProperty("LoggingLevel", this.logEvent.getLevel() != null ? this.logEvent.getLevel().name() : null, metaData);
        ApplicationInsightsLogEvent.addLogEventProperty("ThreadName", this.logEvent.getThreadName(), metaData);
        ApplicationInsightsLogEvent.addLogEventProperty("TimeStamp", ApplicationInsightsLogEvent.getFormattedDate(this.logEvent.getTimeMillis()), metaData);
        if (this.logEvent.isIncludeLocation()) {
            StackTraceElement stackTraceElement = this.logEvent.getSource();
            ApplicationInsightsLogEvent.addLogEventProperty("ClassName", stackTraceElement.getClassName(), metaData);
            ApplicationInsightsLogEvent.addLogEventProperty("FileName", stackTraceElement.getFileName(), metaData);
            ApplicationInsightsLogEvent.addLogEventProperty("MethodName", stackTraceElement.getMethodName(), metaData);
            ApplicationInsightsLogEvent.addLogEventProperty("LineNumber", String.valueOf(stackTraceElement.getLineNumber()), metaData);
        }
        return metaData;
    }
}

