/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.log4j.v2.internal;

import com.microsoft.applicationinsights.internal.common.ApplicationInsightsEvent;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.spi.StandardLevel;

public final class ApplicationInsightsLogEvent
extends ApplicationInsightsEvent {
    private LogEvent logEvent;

    public ApplicationInsightsLogEvent(LogEvent logEvent) {
        this.logEvent = logEvent;
    }

    @Override
    public String getMessage() {
        String message = this.logEvent.getMessage() != null ? this.logEvent.getMessage().getFormattedMessage() : "Log4j Trace";
        return message;
    }

    @Override
    public boolean isException() {
        return this.logEvent.getThrown() != null;
    }

    @Override
    public Exception getException() {
        Exception exception = null;
        if (this.isException()) {
            Throwable throwable = this.logEvent.getThrown();
            exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        }
        return exception;
    }

    @Override
    public Map<String, String> getCustomParameters() {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("SourceType", "Log4j");
        ApplicationInsightsLogEvent.addLogEventProperty("LoggerName", this.logEvent.getLoggerName(), metaData);
        ApplicationInsightsLogEvent.addLogEventProperty("LoggingLevel", this.logEvent.getLevel() != null ? this.logEvent.getLevel().name() : null, metaData);
        ApplicationInsightsLogEvent.addLogEventProperty("ThreadName", this.logEvent.getThreadName(), metaData);
        ApplicationInsightsLogEvent.addLogEventProperty("TimeStamp", ApplicationInsightsLogEvent.getFormattedDate(this.logEvent.getTimeMillis()), metaData);
        if (this.logEvent.isIncludeLocation()) {
            StackTraceElement stackTraceElement = this.logEvent.getSource();
            ApplicationInsightsLogEvent.addLogEventProperty("ClassName", stackTraceElement.getClassName(), metaData);
            ApplicationInsightsLogEvent.addLogEventProperty("FileName", stackTraceElement.getFileName(), metaData);
            ApplicationInsightsLogEvent.addLogEventProperty("MethodName", stackTraceElement.getMethodName(), metaData);
            ApplicationInsightsLogEvent.addLogEventProperty("LineNumber", String.valueOf(stackTraceElement.getLineNumber()), metaData);
        }
        for (Map.Entry entry : this.logEvent.getContextMap().entrySet()) {
            ApplicationInsightsLogEvent.addLogEventProperty((String)entry.getKey(), (String)entry.getValue(), metaData);
        }
        return metaData;
    }

    @Override
    public SeverityLevel getNormalizedSeverityLevel() {
        int log4jLevelAsInt = this.logEvent.getLevel().intLevel();
        switch (StandardLevel.getStandardLevel((int)log4jLevelAsInt)) {
            case FATAL: {
                return SeverityLevel.Critical;
            }
            case ERROR: {
                return SeverityLevel.Error;
            }
            case WARN: {
                return SeverityLevel.Warning;
            }
            case INFO: {
                return SeverityLevel.Information;
            }
            case TRACE: 
            case DEBUG: 
            case ALL: {
                return SeverityLevel.Verbose;
            }
        }
        InternalLogger.INSTANCE.error("Unknown Log4j v2 option, %d, using TRACE level as default", new Object[]{log4jLevelAsInt});
        return SeverityLevel.Verbose;
    }
}

