/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.log4j.v2;

import com.microsoft.applicationinsights.internal.common.LogTelemetryClientProxy;
import com.microsoft.applicationinsights.internal.common.TelemetryClientProxy;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.log4j.v2.internal.ApplicationInsightsLogEvent;
import java.io.Serializable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;

@Plugin(name="ApplicationInsightsAppender", category="Core", elementType="appender")
public class ApplicationInsightsAppender
extends AbstractAppender {
    private boolean isInitialized = false;
    private transient TelemetryClientProxy telemetryClientProxy;
    private static final long serialVersionUID = 1L;

    protected ApplicationInsightsAppender(String name, String instrumentationKey) {
        super(name, null, null);
        try {
            this.telemetryClientProxy = new LogTelemetryClientProxy(instrumentationKey);
            this.isInitialized = true;
        }
        catch (Exception e) {
            this.isInitialized = false;
            InternalLogger.INSTANCE.error("Failed to initialize appender with exception: %s. Generated Stack trace is %s.", new Object[]{e.toString(), ExceptionUtils.getStackTrace((Throwable)e)});
        }
    }

    protected ApplicationInsightsAppender(String name, String instrumentationKey, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        try {
            this.telemetryClientProxy = new LogTelemetryClientProxy(instrumentationKey);
            this.isInitialized = true;
        }
        catch (Exception e) {
            this.isInitialized = false;
            InternalLogger.INSTANCE.error("Failed to initialize appender with exception: %s. Generated Stack trace is %s.", new Object[]{e.toString(), ExceptionUtils.getStackTrace((Throwable)e)});
        }
    }

    public LogTelemetryClientProxy getTelemetryClientProxy() {
        return (LogTelemetryClientProxy)this.telemetryClientProxy;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @PluginFactory
    public static ApplicationInsightsAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="instrumentationKey") String instrumentationKey) {
        return new ApplicationInsightsAppender(name, instrumentationKey);
    }

    public void append(LogEvent event) {
        if (!this.isStarted() || !this.isInitialized) {
            return;
        }
        try {
            ApplicationInsightsLogEvent aiEvent = new ApplicationInsightsLogEvent(event);
            this.telemetryClientProxy.sendEvent(aiEvent);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Something unexpected happened while sending logs %s", new Object[]{ExceptionUtils.getStackTrace((Throwable)e)});
        }
    }

    public void start() {
        super.start();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ApplicationInsightsAppender> {
        @PluginBuilderAttribute
        @Required(message="No name provided for ApplicationInsightsAppender")
        private String name;
        @PluginBuilderAttribute
        private String instrumentationKey;
        @PluginBuilderAttribute
        private boolean ignoreExceptions;
        @PluginElement(value="Layout")
        private Layout<? extends Serializable> layout;
        @PluginElement(value="Filter")
        private Filter filter;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setInstrumentationKey(String instrumentationKey) {
            this.instrumentationKey = instrumentationKey;
            return this;
        }

        public Builder setIgnoreExceptions(boolean ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        public Builder setLayout(Layout<? extends Serializable> layout) {
            this.layout = layout;
            return this;
        }

        public Builder setFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public ApplicationInsightsAppender build() {
            return new ApplicationInsightsAppender(this.name, this.instrumentationKey, this.filter, this.layout, this.ignoreExceptions);
        }
    }
}

