/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.attach;

import io.opentelemetry.contrib.attach.CoreRuntimeAttach;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class ApplicationInsights {
    public static final String APPLICATIONINSIGHTS_RUNTIME_ATTACH_CONFIGURATION_FILE = "applicationinsights.runtime-attach.configuration.classpath.file";
    private static final Logger logger = Logger.getLogger(ApplicationInsights.class.getName());
    private static final String RUNTIME_ATTACHED_ENABLED_PROPERTY = "applicationinsights.internal.runtime.attached";
    private static final String RUNTIME_ATTACHED_JSON_PROPERTY = "applicationinsights.internal.runtime.attached.json";

    private ApplicationInsights() {
    }

    public static void attach() {
        if (ApplicationInsights.agentIsAttached()) {
            logger.warning("Application Insights is already attached. It is not attached a second time.");
            return;
        }
        System.setProperty(RUNTIME_ATTACHED_ENABLED_PROPERTY, "true");
        Optional<String> jsonConfig = ApplicationInsights.findJsonConfig();
        if (jsonConfig.isPresent()) {
            System.setProperty(RUNTIME_ATTACHED_JSON_PROPERTY, jsonConfig.get());
        }
        String appInsightResourceName = ApplicationInsights.findAppInsightResourceName();
        CoreRuntimeAttach runtimeAttach = new CoreRuntimeAttach(appInsightResourceName);
        runtimeAttach.attachJavaagentToCurrentJVM();
    }

    private static Optional<String> findJsonConfig() {
        String fileName = ApplicationInsights.findJsonConfigFile();
        InputStream configContentAsInputStream = ApplicationInsights.findResourceAsStream(fileName);
        if (configContentAsInputStream == null) {
            return Optional.empty();
        }
        String json = ApplicationInsights.findJson(configContentAsInputStream);
        return Optional.of(json);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String findJson(InputStream configContentAsInputStream) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(configContentAsInputStream, StandardCharsets.UTF_8);){
            String string;
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                string = bufferedReader.lines().collect(Collectors.joining(""));
            }
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected issue during loading of JSON configuration file: " + e.getMessage());
        }
    }

    private static InputStream findResourceAsStream(String fileName) {
        InputStream configContentAsInputStream = ApplicationInsights.class.getResourceAsStream("/" + fileName);
        if (configContentAsInputStream == null && ApplicationInsights.isJsonFileConfiguredWithProperty()) {
            throw new ConfigurationException(fileName + " not found on the class path");
        }
        return configContentAsInputStream;
    }

    private static String findJsonConfigFile() {
        if (ApplicationInsights.isJsonFileConfiguredWithProperty()) {
            return System.getProperty(APPLICATIONINSIGHTS_RUNTIME_ATTACH_CONFIGURATION_FILE);
        }
        return "applicationinsights.json";
    }

    private static boolean isJsonFileConfiguredWithProperty() {
        return System.getProperty(APPLICATIONINSIGHTS_RUNTIME_ATTACH_CONFIGURATION_FILE) != null;
    }

    private static boolean agentIsAttached() {
        try {
            Class.forName("io.opentelemetry.javaagent.OpenTelemetryAgent", false, null);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static String findAppInsightResourceName() {
        String appInsightVersion = ApplicationInsights.findAppInsightVersion();
        return "/applicationinsights-agent-" + appInsightVersion + ".jar";
    }

    private static String findAppInsightVersion() {
        String string;
        block8: {
            InputStream jarAsInputStream = ApplicationInsights.class.getResourceAsStream("/ai.sdk-version.properties");
            try {
                Properties props = new Properties();
                props.load(jarAsInputStream);
                string = props.getProperty("version");
                if (jarAsInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jarAsInputStream != null) {
                        try {
                            jarAsInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to find Application Insights version", e);
                }
            }
            jarAsInputStream.close();
        }
        return string;
    }

    public static class ConfigurationException
    extends IllegalArgumentException {
        ConfigurationException(String message) {
            super(message);
        }
    }
}

