/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.boot.HeartBeatProvider;

import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatPayloadProviderInterface;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatProviderInterface;
import com.microsoft.applicationinsights.internal.heartbeat.MiscUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.PropertyHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.boot.SpringBootVersion;
import org.springframework.core.SpringVersion;
import org.springframework.core.env.Environment;

public class SpringBootHeartBeatProvider
implements HeartBeatPayloadProviderInterface {
    private final Set<String> defaultFields = new HashSet<String>();
    private final String name = "SpringBootProvider";
    private final Environment environment;
    private final String SPRING_BOOT_VERSION = "ai.spring-boot.version";
    private final String SPRING_VERSION = "ai.spring.version";
    private final String SPRING_BOOT_STARTER_VERSION = "ai.spring.boot.starter.version";

    public SpringBootHeartBeatProvider(Environment environment) {
        this.environment = environment;
        this.initializeDefaultFields(this.defaultFields);
    }

    public String getName() {
        return this.name;
    }

    public boolean isKeyword(String keyword) {
        return this.defaultFields.contains(keyword);
    }

    public Callable<Boolean> setDefaultPayload(final List<String> disableFields, final HeartBeatProviderInterface provider) {
        return new Callable<Boolean>(){
            Set<String> enabledProperties;
            {
                this.enabledProperties = MiscUtils.except((List)disableFields, (Set)SpringBootHeartBeatProvider.this.defaultFields);
            }

            @Override
            public Boolean call() {
                boolean hasSetValues = false;
                for (String fieldName : this.enabledProperties) {
                    try {
                        switch (fieldName) {
                            case "ai.spring-boot.version": {
                                provider.addHeartBeatProperty(fieldName, SpringBootHeartBeatProvider.this.getSpringBootVersion(), true);
                                hasSetValues = true;
                                break;
                            }
                            case "ai.spring.version": {
                                provider.addHeartBeatProperty(fieldName, SpringBootHeartBeatProvider.this.getSpringVersion(), true);
                                hasSetValues = true;
                                break;
                            }
                            case "ai.spring.boot.starter.version": {
                                provider.addHeartBeatProperty(fieldName, SpringBootHeartBeatProvider.this.getSpringBootStarterVersionNumber(), true);
                            }
                            default: {
                                InternalLogger.INSTANCE.trace("Encountered unknown default property", new Object[0]);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        InternalLogger.INSTANCE.warn("Failed to obtain heartbeat property, stack traceis: %s", new Object[]{ExceptionUtils.getStackTrace((Throwable)e)});
                    }
                }
                return hasSetValues;
            }
        };
    }

    private void initializeDefaultFields(Set<String> defaultFields) {
        defaultFields.add("ai.spring-boot.version");
        defaultFields.add("ai.spring.version");
        defaultFields.add("ai.spring.boot.starter.version");
    }

    private String getSpringBootVersion() {
        return SpringBootVersion.getVersion();
    }

    private String getSpringVersion() {
        return SpringVersion.getVersion();
    }

    private String getSpringBootStarterVersionNumber() {
        Properties starterVersionProperties = PropertyHelper.getStarterVersionProperties();
        if (starterVersionProperties != null) {
            return starterVersionProperties.getProperty("version");
        }
        return "undefined";
    }
}

