/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.boot;

import com.microsoft.applicationinsights.boot.ApplicationInsightsProperties;
import com.microsoft.applicationinsights.boot.HeartBeatProvider.SpringBootHeartBeatProvider;
import com.microsoft.applicationinsights.boot.initializer.SpringBootTelemetryInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.extensibility.initializer.DeviceInfoContextInitializer;
import com.microsoft.applicationinsights.extensibility.initializer.SdkVersionContextInitializer;
import com.microsoft.applicationinsights.internal.channel.samplingV2.FixedRateSamplingTelemetryProcessor;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatModule;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatPayloadProviderInterface;
import com.microsoft.applicationinsights.internal.heartbeat.HeartbeatDefaultPayload;
import com.microsoft.applicationinsights.internal.perfcounter.JvmPerformanceCountersModule;
import com.microsoft.applicationinsights.internal.perfcounter.ProcessPerformanceCountersModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={ApplicationInsightsProperties.class})
@ConditionalOnProperty(value={"azure.application-insights.enabled"}, havingValue="true", matchIfMissing=true)
public class ApplicationInsightsModuleConfiguration {
    private ApplicationInsightsProperties applicationInsightsProperties;

    @Autowired
    public ApplicationInsightsModuleConfiguration(ApplicationInsightsProperties properties) {
        this.applicationInsightsProperties = properties;
    }

    @Bean
    public SdkVersionContextInitializer sdkVersionContextInitializer() {
        return new SdkVersionContextInitializer();
    }

    @Bean
    public DeviceInfoContextInitializer deviceInfoContextInitializer() {
        return new DeviceInfoContextInitializer();
    }

    @Bean
    public SpringBootTelemetryInitializer springBootTelemetryInitializer() {
        return new SpringBootTelemetryInitializer();
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.default-modules.ProcessPerformanceCountersModule.enabled"}, havingValue="true", matchIfMissing=true)
    public ProcessPerformanceCountersModule processPerformanceCountersModule() {
        try {
            return new ProcessPerformanceCountersModule();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize Windows performance counters module, please set property 'azure.application-insights.default-modules.ProcessPerformanceCountersModule.enabled=false' to avoid this error message.", e);
        }
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.default.modules.JvmPerformanceCountersModule.enabled"}, havingValue="true", matchIfMissing=true)
    public JvmPerformanceCountersModule jvmPerformanceCountersModule() {
        try {
            return new JvmPerformanceCountersModule();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize Jvm Performance Counters module please set the property 'azure.application-insights.default.modules.JvmPerformanceCountersModule.enabled=false' to avoid this error message", e);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public HeartBeatPayloadProviderInterface heartBeatProviderInterface(Environment environment) {
        return new SpringBootHeartBeatProvider(environment);
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.heart-beat.enabled"}, havingValue="true", matchIfMissing=true)
    public HeartBeatModule heartBeatModule(HeartBeatPayloadProviderInterface heartBeatPayloadProviderInterface) {
        try {
            HeartBeatModule heartBeatModule = new HeartBeatModule();
            HeartbeatDefaultPayload.addDefaultPayLoadProvider((HeartBeatPayloadProviderInterface)heartBeatPayloadProviderInterface);
            ApplicationInsightsProperties.HeartBeat heartBeat = this.applicationInsightsProperties.getHeartBeat();
            heartBeatModule.setHeartBeatInterval(heartBeat.getHeartBeatInterval());
            if (heartBeat.getExcludedHeartBeatPropertiesList().size() > 0) {
                heartBeatModule.setExcludedHeartBeatProperties(heartBeat.getExcludedHeartBeatPropertiesList());
            }
            if (heartBeat.getExcludedHeartBeatProviderList().size() > 0) {
                heartBeatModule.setExcludedHeartBeatPropertiesProvider(heartBeat.getExcludedHeartBeatProviderList());
            }
            return heartBeatModule;
        }
        catch (Exception e) {
            throw new IllegalStateException("could not configure Heartbeat, please set 'azure.application-insights.heart-beat.enabled' to false ", e);
        }
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.telemetry-processor.sampling.enabled"}, havingValue="true")
    public TelemetryProcessor fixedRateSamplingTelemetryProcessor() {
        ApplicationInsightsProperties.TelemetryProcessor.Sampling sampling = this.applicationInsightsProperties.getTelemetryProcessor().getSampling();
        FixedRateSamplingTelemetryProcessor processor = new FixedRateSamplingTelemetryProcessor();
        processor.setSamplingPercentage(String.valueOf(sampling.getPercentage()));
        for (String include : sampling.getInclude()) {
            processor.addToIncludedType(include);
        }
        for (String exclude : sampling.getExclude()) {
            processor.addToExcludedType(exclude);
        }
        return processor;
    }
}

