/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.boot;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.boot.ApplicationInsightsModuleConfiguration;
import com.microsoft.applicationinsights.boot.ApplicationInsightsProperties;
import com.microsoft.applicationinsights.boot.ApplicationInsightsWebModuleConfiguration;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.channel.concrete.inprocess.InProcessTelemetryChannel;
import com.microsoft.applicationinsights.extensibility.ContextInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounterContainer;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(value={"azure.application-insights.instrumentation-key"})
@EnableConfigurationProperties(value={ApplicationInsightsProperties.class})
@ConditionalOnClass(value={TelemetryConfiguration.class})
@Import(value={ApplicationInsightsModuleConfiguration.class, ApplicationInsightsWebModuleConfiguration.class})
public class ApplicationInsightsTelemetryAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ApplicationInsightsTelemetryAutoConfiguration.class);
    private ApplicationInsightsProperties applicationInsightsProperties;
    private Collection<ContextInitializer> contextInitializers;
    private Collection<TelemetryInitializer> telemetryInitializers;
    private Collection<TelemetryModule> telemetryModules;
    private Collection<TelemetryProcessor> telemetryProcessors;

    @Autowired
    public ApplicationInsightsTelemetryAutoConfiguration(ApplicationInsightsProperties applicationInsightsProperties) {
        this.applicationInsightsProperties = applicationInsightsProperties;
    }

    @Autowired(required=false)
    public void setContextInitializers(Collection<ContextInitializer> contextInitializers) {
        this.contextInitializers = contextInitializers;
    }

    @Autowired(required=false)
    public void setTelemetryInitializers(Collection<TelemetryInitializer> telemetryInitializers) {
        this.telemetryInitializers = telemetryInitializers;
    }

    @Autowired(required=false)
    public void setTelemetryModules(Collection<TelemetryModule> telemetryModules) {
        this.telemetryModules = telemetryModules;
    }

    @Autowired(required=false)
    public void setTelemetryProcessors(Collection<TelemetryProcessor> telemetryProcessors) {
        this.telemetryProcessors = telemetryProcessors;
    }

    @Bean
    @DependsOn(value={"internalLogger"})
    public TelemetryConfiguration telemetryConfiguration(TelemetryChannel telemetryChannel) {
        TelemetryConfiguration telemetryConfiguration = TelemetryConfiguration.getActiveWithoutInitializingConfig();
        telemetryConfiguration.setTrackingIsDisabled(!this.applicationInsightsProperties.isEnabled());
        telemetryConfiguration.setInstrumentationKey(this.applicationInsightsProperties.getInstrumentationKey());
        if (this.contextInitializers != null) {
            telemetryConfiguration.getContextInitializers().addAll(this.contextInitializers);
        }
        if (this.telemetryInitializers != null) {
            telemetryConfiguration.getTelemetryInitializers().addAll(this.telemetryInitializers);
        }
        if (this.telemetryModules != null) {
            telemetryConfiguration.getTelemetryModules().addAll(this.telemetryModules);
        }
        if (this.telemetryProcessors != null) {
            telemetryConfiguration.getTelemetryProcessors().addAll(this.telemetryProcessors);
        }
        telemetryConfiguration.setChannel(telemetryChannel);
        this.initializeComponents(telemetryConfiguration);
        return telemetryConfiguration;
    }

    private void initializeComponents(TelemetryConfiguration configuration) {
        List telemetryModules = configuration.getTelemetryModules();
        for (TelemetryModule module : telemetryModules) {
            try {
                module.initialize(configuration);
            }
            catch (Exception e) {
                log.error("Failed to initialized telemetry module " + module.getClass().getSimpleName(), (Throwable)e);
            }
        }
    }

    @Bean
    public TelemetryClient telemetryClient(TelemetryConfiguration configuration) {
        return new TelemetryClient(configuration);
    }

    @Bean
    @ConditionalOnMissingBean
    public TelemetryChannel telemetryChannel() {
        ApplicationInsightsProperties.Channel.InProcess inProcess = this.applicationInsightsProperties.getChannel().getInProcess();
        return new InProcessTelemetryChannel(inProcess.getEndpointAddress(), String.valueOf(inProcess.getMaxTransmissionStorageFilesCapacityInMb()), inProcess.isDeveloperMode(), inProcess.getMaxTelemetryBufferCapacity(), inProcess.getFlushIntervalInSeconds(), inProcess.isThrottling(), inProcess.getMaxInstantRetry());
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.quick-pulse.enabled"}, havingValue="true", matchIfMissing=true)
    @DependsOn(value={"telemetryConfiguration"})
    public QuickPulse quickPulse() {
        QuickPulse.INSTANCE.initialize();
        return QuickPulse.INSTANCE;
    }

    @Bean
    public InternalLogger internalLogger() {
        HashMap<String, String> loggerParameters = new HashMap<String, String>();
        ApplicationInsightsProperties.Logger logger = this.applicationInsightsProperties.getLogger();
        loggerParameters.put("Level", logger.getLevel().name());
        InternalLogger.INSTANCE.initialize(logger.getType().name(), loggerParameters);
        return InternalLogger.INSTANCE;
    }

    @PostConstruct
    public void initializePerformanceCounterContainer() {
        ApplicationInsightsProperties.PerformanceCounter performanceCounter = this.applicationInsightsProperties.getPerformanceCounter();
        PerformanceCounterContainer.INSTANCE.setCollectionFrequencyInSec(performanceCounter.getCollectionFrequencyInSeconds());
        ApplicationInsightsProperties.Jmx jmx = this.applicationInsightsProperties.getJmx();
        if (jmx.getJmxCounters() != null && jmx.getJmxCounters().size() > 0) {
            this.applicationInsightsProperties.processAndLoadJmxCounters(jmx.getJmxCounters());
        }
    }
}

