/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.boot;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.boot.ApplicationInsightsTelemetryAutoConfiguration;
import com.microsoft.applicationinsights.web.internal.WebRequestTrackingFilter;
import com.microsoft.applicationinsights.web.spring.internal.InterceptorRegistry;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={InterceptorRegistry.class})
@ConditionalOnBean(value={TelemetryConfiguration.class})
@ConditionalOnWebApplication
@ConditionalOnProperty(value={"azure.application-insights.web.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={ApplicationInsightsTelemetryAutoConfiguration.class})
public class ApplicationInsightsWebMvcAutoConfiguration {
    @Bean
    public FilterRegistrationBean webRequestTrackingFilterRegistrationBean(WebRequestTrackingFilter webRequestTrackingFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)webRequestTrackingFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(-2147483638);
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean
    @DependsOn(value={"telemetryConfiguration"})
    public WebRequestTrackingFilter webRequestTrackingFilter(@Value(value="${spring.application.name:application}") String applicationName) {
        return new WebRequestTrackingFilter(applicationName);
    }
}

