/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.autoconfigure;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.autoconfigure.ApplicationInsightsTelemetryAutoConfiguration;
import com.microsoft.applicationinsights.web.internal.ApplicationInsightsServletContextListener;
import com.microsoft.applicationinsights.web.internal.WebRequestTrackingFilter;
import com.microsoft.applicationinsights.web.spring.internal.InterceptorRegistry;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.ServletContextListener;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={InterceptorRegistry.class})
@ConditionalOnBean(value={TelemetryConfiguration.class})
@ConditionalOnWebApplication
@ConditionalOnProperty(value={"azure.application-insights.web.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={ApplicationInsightsTelemetryAutoConfiguration.class})
public class ApplicationInsightsWebMvcAutoConfiguration {
    @Bean
    public FilterRegistrationBean webRequestTrackingFilterRegistrationBean(WebRequestTrackingFilter webRequestTrackingFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)webRequestTrackingFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    @Bean
    public ServletListenerRegistrationBean<ServletContextListener> appInsightsServletContextListenerRegistrationBean(ApplicationInsightsServletContextListener applicationInsightsServletContextListener) {
        ServletListenerRegistrationBean srb = new ServletListenerRegistrationBean();
        srb.setListener((EventListener)applicationInsightsServletContextListener);
        return srb;
    }

    @Bean
    @ConditionalOnMissingBean
    @DependsOn(value={"telemetryConfiguration"})
    public WebRequestTrackingFilter webRequestTrackingFilter(@Value(value="${spring.application.name:application}") String applicationName) {
        return new WebRequestTrackingFilter(applicationName);
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationInsightsServletContextListener applicationInsightsServletContextListener() {
        return new ApplicationInsightsServletContextListener();
    }
}

