/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.autoconfigure.conditionals;

import com.microsoft.applicationinsights.autoconfigure.helpers.IkeyResolver;
import com.microsoft.applicationinsights.boot.dependencies.apachecommons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class InstrumentationKeyCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String iKey = context.getEnvironment().getProperty("azure.application-insights.instrumentation-key");
        if (StringUtils.isNoneBlank(iKey)) {
            return new ConditionOutcome(true, ConditionMessage.of((String)"instrumentation key found", (Object[])new Object[0]));
        }
        iKey = IkeyResolver.getIkeyFromEnvironmentVariables();
        if (StringUtils.isNoneBlank(iKey)) {
            return new ConditionOutcome(true, ConditionMessage.of((String)"instrumentation key found", (Object[])new Object[0]));
        }
        return new ConditionOutcome(false, ConditionMessage.of((String)"instrumentation key not found", (Object[])new Object[0]));
    }
}

