/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.boot.dependencies.google.common.cache;

import com.microsoft.applicationinsights.boot.dependencies.google.common.annotations.GwtIncompatible;
import com.microsoft.applicationinsights.boot.dependencies.google.common.base.Preconditions;
import com.microsoft.applicationinsights.boot.dependencies.google.common.cache.RemovalListener;
import com.microsoft.applicationinsights.boot.dependencies.google.common.cache.RemovalNotification;
import java.util.concurrent.Executor;

@GwtIncompatible
public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(final RemovalListener<K, V> listener, final Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        return new RemovalListener<K, V>(){

            @Override
            public void onRemoval(final RemovalNotification<K, V> notification) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRemoval(notification);
                    }
                });
            }
        };
    }
}

