/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.autoconfigure;

import com.microsoft.applicationinsights.autoconfigure.helpers.IkeyResolver;
import com.microsoft.applicationinsights.boot.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.boot.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatProvider;
import com.microsoft.applicationinsights.internal.jmx.JmxAttributeData;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.JmxMetricPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounterContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="azure.application-insights")
public class ApplicationInsightsProperties {
    private boolean enabled = true;
    private String instrumentationKey;
    private Channel channel = new Channel();
    private TelemetryProcessor telemetryProcessor = new TelemetryProcessor();
    private Web web = new Web();
    private QuickPulse quickPulse = new QuickPulse();
    private Logger logger = new Logger();
    private PerformanceCounter performanceCounter = new PerformanceCounter();
    private Jmx jmx = new Jmx();
    private HeartBeat heartBeat = new HeartBeat();
    private String connectionString;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getInstrumentationKey() {
        String v = IkeyResolver.getIkeyFromEnvironmentVariables();
        if (v != null) {
            return v;
        }
        return this.instrumentationKey;
    }

    public void setInstrumentationKey(String instrumentationKey) {
        this.instrumentationKey = instrumentationKey;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public TelemetryProcessor getTelemetryProcessor() {
        return this.telemetryProcessor;
    }

    public void setTelemetryProcessor(TelemetryProcessor telemetryProcessor) {
        this.telemetryProcessor = telemetryProcessor;
    }

    public Web getWeb() {
        return this.web;
    }

    public void setWeb(Web web) {
        this.web = web;
    }

    public QuickPulse getQuickPulse() {
        return this.quickPulse;
    }

    public void setQuickPulse(QuickPulse quickPulse) {
        this.quickPulse = quickPulse;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public PerformanceCounter getPerformanceCounter() {
        return this.performanceCounter;
    }

    public void setPerformanceCounter(PerformanceCounter performanceCounter) {
        this.performanceCounter = performanceCounter;
    }

    public Jmx getJmx() {
        return this.jmx;
    }

    public void setJmx(Jmx jmx) {
        this.jmx = jmx;
    }

    public HeartBeat getHeartBeat() {
        return this.heartBeat;
    }

    public void setHeartBeat(HeartBeat heartBeat) {
        this.heartBeat = heartBeat;
    }

    public String getConnectionString() {
        String nextValue = System.getenv("APPLICATIONINSIGHTS_CONNECTION_STRING");
        if (StringUtils.isNotEmpty(nextValue)) {
            if (StringUtils.isNotEmpty(this.connectionString)) {
                InternalLogger.INSTANCE.warn("Environment variable %s is overriding connection string value from application.properties", new Object[]{"APPLICATIONINSIGHTS_CONNECTION_STRING"});
            }
            return nextValue;
        }
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    void processAndLoadJmxCounters(List<String> jmxCounterList) {
        try {
            HashMap<String, ArrayList<JmxAttributeData>> data = new HashMap<String, ArrayList<JmxAttributeData>>();
            for (String string : jmxCounterList) {
                CompositeJmxData compositeJmxData = this.convertToCompositeJmxData(string);
                if (compositeJmxData == null) {
                    InternalLogger.INSTANCE.warn("unable to add Jmx counter %s", new Object[]{string});
                    continue;
                }
                ArrayList<JmxAttributeData> collection = (ArrayList<JmxAttributeData>)data.get(compositeJmxData.getObjectName());
                if (collection == null) {
                    collection = new ArrayList<JmxAttributeData>();
                    data.put(compositeJmxData.getObjectName(), collection);
                }
                collection.add(new JmxAttributeData(compositeJmxData.getDisplayName(), compositeJmxData.getAttributeName(), compositeJmxData.getType()));
            }
            for (Map.Entry entry : data.entrySet()) {
                try {
                    if (PerformanceCounterContainer.INSTANCE.register((com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounter)new JmxMetricPerformanceCounter((String)entry.getKey(), (String)entry.getKey(), (Collection)entry.getValue()))) {
                        InternalLogger.INSTANCE.trace("Registered Jmx performance counter %s", new Object[]{entry.getKey()});
                        continue;
                    }
                    InternalLogger.INSTANCE.trace("Failed to register Jmx performance counter %s", new Object[]{entry.getKey()});
                }
                catch (Exception e) {
                    InternalLogger.INSTANCE.warn("Failed to register Jmx performance counter, of object name %s Stack trace is %s", new Object[]{entry.getKey(), ExceptionUtils.getStackTrace(e)});
                }
            }
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.warn("Unable to add Jmx performance counter. Exception is %s", new Object[]{ExceptionUtils.getStackTrace(e)});
        }
    }

    private CompositeJmxData convertToCompositeJmxData(String jmxCounter) {
        if (jmxCounter != null && jmxCounter.length() > 0) {
            String[] attributes = jmxCounter.split("/");
            if (attributes.length < 3) {
                InternalLogger.INSTANCE.warn("Missing either objectName or attributeName or display name. Jmx counter %s will not be added", new Object[]{jmxCounter});
                return null;
            }
            CompositeJmxData data = new CompositeJmxData();
            for (int i = 0; i < attributes.length && i <= 3; ++i) {
                if (i == 0) {
                    data.setObjectName(attributes[0]);
                    continue;
                }
                if (i == 1) {
                    data.setAttributeName(attributes[1]);
                    continue;
                }
                if (i == 2) {
                    data.setDisplayName(attributes[2]);
                    continue;
                }
                data.setType(attributes[3]);
            }
            return data;
        }
        return null;
    }

    private static class CompositeJmxData {
        String displayName;
        String objectName;
        String attributeName;
        String type;

        private CompositeJmxData() {
        }

        String getDisplayName() {
            return this.displayName;
        }

        void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        String getObjectName() {
            return this.objectName;
        }

        void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        String getAttributeName() {
            return this.attributeName;
        }

        void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        String getType() {
            return this.type;
        }

        void setType(String type) {
            this.type = type;
            if (this.type != null) {
                this.type = this.type.toUpperCase();
            }
        }
    }

    static class HeartBeat {
        private boolean enabled = false;
        private long heartBeatInterval = HeartBeatProvider.DEFAULT_HEARTBEAT_INTERVAL;
        private List<String> excludedHeartBeatProviderList = new ArrayList<String>();
        private List<String> excludedHeartBeatPropertiesList = new ArrayList<String>();

        HeartBeat() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public long getHeartBeatInterval() {
            return this.heartBeatInterval;
        }

        public void setHeartBeatInterval(long heartBeatInterval) {
            this.heartBeatInterval = heartBeatInterval;
        }

        public List<String> getExcludedHeartBeatProviderList() {
            return this.excludedHeartBeatProviderList;
        }

        public void setExcludedHeartBeatProviderList(List<String> excludedHeartBeatProviderList) {
            this.excludedHeartBeatProviderList = excludedHeartBeatProviderList;
        }

        public List<String> getExcludedHeartBeatPropertiesList() {
            return this.excludedHeartBeatPropertiesList;
        }

        public void setExcludedHeartBeatPropertiesList(List<String> excludedHeartBeatPropertiesList) {
            this.excludedHeartBeatPropertiesList = excludedHeartBeatPropertiesList;
        }
    }

    static class Jmx {
        private List<String> jmxCounters = new ArrayList<String>();

        Jmx() {
        }

        public List<String> getJmxCounters() {
            return this.jmxCounters;
        }

        public void setJmxCounters(List<String> jmxCounters) {
            this.jmxCounters = jmxCounters;
        }
    }

    static class PerformanceCounter {
        private long collectionFrequencyInSeconds = 60L;

        PerformanceCounter() {
        }

        public long getCollectionFrequencyInSeconds() {
            return this.collectionFrequencyInSeconds;
        }

        public void setCollectionFrequencyInSeconds(long collectionFrequencyInSeconds) {
            this.collectionFrequencyInSeconds = collectionFrequencyInSeconds;
        }
    }

    static class Logger {
        private InternalLogger.LoggerOutputType type = InternalLogger.LoggerOutputType.CONSOLE;
        private InternalLogger.LoggingLevel level = InternalLogger.LoggingLevel.OFF;
        private String uniquePrefix = "AI";
        private String BaseFolderPath;
        private String numberOfFiles;
        private String numberOfTotalSizeInMB;

        Logger() {
        }

        public String getUniquePrefix() {
            return this.uniquePrefix;
        }

        public void setUniquePrefix(String uniquePrefix) {
            this.uniquePrefix = uniquePrefix;
        }

        public String getBaseFolderPath() {
            return this.BaseFolderPath;
        }

        public void setBaseFolderPath(String baseFolderPath) {
            this.BaseFolderPath = baseFolderPath;
        }

        public String getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public void setNumberOfFiles(String numberOfFiles) {
            this.numberOfFiles = numberOfFiles;
        }

        public String getNumberOfTotalSizeInMB() {
            return this.numberOfTotalSizeInMB;
        }

        public void setNumberOfTotalSizeInMB(String numberOfTotalSizeInMB) {
            this.numberOfTotalSizeInMB = numberOfTotalSizeInMB;
        }

        public InternalLogger.LoggerOutputType getType() {
            return this.type;
        }

        public void setType(InternalLogger.LoggerOutputType type) {
            this.type = type;
        }

        public InternalLogger.LoggingLevel getLevel() {
            return this.level;
        }

        public void setLevel(InternalLogger.LoggingLevel level) {
            this.level = level;
        }
    }

    public static class QuickPulse {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    static class Web {
        private boolean enabled = true;
        private boolean enableW3C = false;
        private boolean enableW3CBackcompatMode = true;

        Web() {
        }

        public boolean isEnableW3CBackcompatMode() {
            return this.enableW3CBackcompatMode;
        }

        public void setEnableW3CBackcompatMode(boolean enableW3CBackcompatMode) {
            this.enableW3CBackcompatMode = enableW3CBackcompatMode;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnableW3C() {
            return this.enableW3C;
        }

        public void setEnableW3C(boolean enableW3C) {
            this.enableW3C = enableW3C;
        }
    }

    static class TelemetryProcessor {
        private Sampling sampling = new Sampling();

        TelemetryProcessor() {
        }

        public Sampling getSampling() {
            return this.sampling;
        }

        public void setSampling(Sampling sampling) {
            this.sampling = sampling;
        }

        static class Sampling {
            private boolean enabled = false;
            private double percentage = 100.0;
            private List<String> include = new ArrayList<String>();
            private List<String> exclude = new ArrayList<String>();

            Sampling() {
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public double getPercentage() {
                return this.percentage;
            }

            public void setPercentage(double percentage) {
                this.percentage = percentage;
            }

            public List<String> getInclude() {
                return this.include;
            }

            public void setInclude(List<String> include) {
                this.include = include;
            }

            public List<String> getExclude() {
                return this.exclude;
            }

            public void setExclude(List<String> exclude) {
                this.exclude = exclude;
            }
        }
    }

    static class Channel {
        private InProcess inProcess = new InProcess();
        private LocalForwarder localForwarder = new LocalForwarder();

        Channel() {
        }

        public LocalForwarder getLocalForwarder() {
            return this.localForwarder;
        }

        public void setLocalForwarder(LocalForwarder localForwarder) {
            this.localForwarder = localForwarder;
        }

        public InProcess getInProcess() {
            return this.inProcess;
        }

        public void setInProcess(InProcess inProcess) {
            this.inProcess = inProcess;
        }

        static class LocalForwarder {
            private String endpointAddress;
            private int maxTelemetryBufferCapacity = 500;
            private int flushIntervalInSeconds = 5;

            LocalForwarder() {
            }

            public int getMaxTelemetryBufferCapacity() {
                return this.maxTelemetryBufferCapacity;
            }

            public void setMaxTelemetryBufferCapacity(int maxTelemetryBufferCapacity) {
                this.maxTelemetryBufferCapacity = maxTelemetryBufferCapacity;
            }

            public int getFlushIntervalInSeconds() {
                return this.flushIntervalInSeconds;
            }

            public void setFlushIntervalInSeconds(int flushIntervalInSeconds) {
                this.flushIntervalInSeconds = flushIntervalInSeconds;
            }

            public String getEndpointAddress() {
                return this.endpointAddress;
            }

            public void setEndpointAddress(String endpointAddress) {
                this.endpointAddress = endpointAddress;
            }
        }

        static class InProcess {
            private boolean developerMode = false;
            private String endpointAddress;
            private int maxTelemetryBufferCapacity = 500;
            private int flushIntervalInSeconds = 5;
            private int maxTransmissionStorageFilesCapacityInMb = 10;
            private boolean throttling = true;
            private int maxInstantRetry = 3;

            InProcess() {
            }

            public boolean isDeveloperMode() {
                return this.developerMode;
            }

            public void setDeveloperMode(boolean developerMode) {
                this.developerMode = developerMode;
            }

            public int getMaxInstantRetry() {
                return this.maxInstantRetry;
            }

            public void setMaxInstantRetry(int maxInstantRetry) {
                this.maxInstantRetry = maxInstantRetry;
            }

            public String getEndpointAddress() {
                return this.endpointAddress;
            }

            public void setEndpointAddress(String endpointAddress) {
                this.endpointAddress = endpointAddress;
            }

            public int getMaxTelemetryBufferCapacity() {
                return this.maxTelemetryBufferCapacity;
            }

            public void setMaxTelemetryBufferCapacity(int maxTelemetryBufferCapacity) {
                this.maxTelemetryBufferCapacity = maxTelemetryBufferCapacity;
            }

            public int getFlushIntervalInSeconds() {
                return this.flushIntervalInSeconds;
            }

            public void setFlushIntervalInSeconds(int flushIntervalInSeconds) {
                this.flushIntervalInSeconds = flushIntervalInSeconds;
            }

            public int getMaxTransmissionStorageFilesCapacityInMb() {
                return this.maxTransmissionStorageFilesCapacityInMb;
            }

            public void setMaxTransmissionStorageFilesCapacityInMb(int maxTransmissionStorageFilesCapacityInMb) {
                this.maxTransmissionStorageFilesCapacityInMb = maxTransmissionStorageFilesCapacityInMb;
            }

            public boolean isThrottling() {
                return this.throttling;
            }

            public void setThrottling(boolean throttling) {
                this.throttling = throttling;
            }
        }
    }
}

