/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.autoconfigure;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.autoconfigure.ApplicationInsightsModuleConfiguration;
import com.microsoft.applicationinsights.autoconfigure.ApplicationInsightsProperties;
import com.microsoft.applicationinsights.autoconfigure.ApplicationInsightsWebModuleConfiguration;
import com.microsoft.applicationinsights.autoconfigure.conditionals.InstrumentationKeyCondition;
import com.microsoft.applicationinsights.boot.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.channel.concrete.inprocess.InProcessTelemetryChannel;
import com.microsoft.applicationinsights.channel.concrete.localforwarder.LocalForwarderTelemetryChannel;
import com.microsoft.applicationinsights.exceptions.IllegalConfigurationException;
import com.microsoft.applicationinsights.extensibility.ContextInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounterContainer;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={InstrumentationKeyCondition.class})
@EnableConfigurationProperties(value={ApplicationInsightsProperties.class})
@ConditionalOnClass(value={TelemetryConfiguration.class})
@Import(value={ApplicationInsightsModuleConfiguration.class, ApplicationInsightsWebModuleConfiguration.class})
@AutoConfigureBefore(name={"io.micrometer.spring.autoconfigure.export.azuremonitor.AzureMonitorMetricsExportAutoConfiguration", "com.microsoft.azure.spring.autoconfigure.metrics.AzureMonitorMetricsExportAutoConfiguration"})
public class ApplicationInsightsTelemetryAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ApplicationInsightsTelemetryAutoConfiguration.class);
    private ApplicationInsightsProperties applicationInsightsProperties;
    private Collection<ContextInitializer> contextInitializers;
    private Collection<TelemetryInitializer> telemetryInitializers;
    private Collection<TelemetryModule> telemetryModules;
    private Collection<TelemetryProcessor> telemetryProcessors;
    @Autowired
    private Environment environment;

    @Autowired
    public ApplicationInsightsTelemetryAutoConfiguration(ApplicationInsightsProperties applicationInsightsProperties) {
        this.applicationInsightsProperties = applicationInsightsProperties;
    }

    @Autowired(required=false)
    public void setContextInitializers(Collection<ContextInitializer> contextInitializers) {
        this.contextInitializers = contextInitializers;
    }

    @Autowired(required=false)
    public void setTelemetryInitializers(Collection<TelemetryInitializer> telemetryInitializers) {
        this.telemetryInitializers = telemetryInitializers;
    }

    @Autowired(required=false)
    public void setTelemetryModules(Collection<TelemetryModule> telemetryModules) {
        this.telemetryModules = telemetryModules;
    }

    @Autowired(required=false)
    public void setTelemetryProcessors(Collection<TelemetryProcessor> telemetryProcessors) {
        this.telemetryProcessors = telemetryProcessors;
    }

    @Bean
    @DependsOn(value={"internalLogger"})
    public TelemetryConfiguration telemetryConfiguration() {
        TelemetryConfiguration telemetryConfiguration = TelemetryConfiguration.getActiveWithoutInitializingConfig();
        if (StringUtils.isNotEmpty(this.applicationInsightsProperties.getConnectionString())) {
            telemetryConfiguration.setConnectionString(this.applicationInsightsProperties.getConnectionString());
        }
        telemetryConfiguration.setTrackingIsDisabled(!this.applicationInsightsProperties.isEnabled());
        if (StringUtils.isNotEmpty(this.applicationInsightsProperties.getInstrumentationKey())) {
            telemetryConfiguration.setInstrumentationKey(this.applicationInsightsProperties.getInstrumentationKey());
        }
        if (StringUtils.isEmpty(telemetryConfiguration.getInstrumentationKey())) {
            throw new IllegalStateException("Could not find instrumentation key or connection string");
        }
        if (this.contextInitializers != null) {
            telemetryConfiguration.getContextInitializers().addAll(this.contextInitializers);
        }
        if (this.telemetryInitializers != null) {
            telemetryConfiguration.getTelemetryInitializers().addAll(this.telemetryInitializers);
        }
        if (this.telemetryModules != null) {
            telemetryConfiguration.getTelemetryModules().addAll(this.telemetryModules);
        }
        if (this.telemetryProcessors != null) {
            telemetryConfiguration.getTelemetryProcessors().addAll(this.telemetryProcessors);
        }
        this.initializeComponents(telemetryConfiguration);
        this.initializePerformanceCounterContainer();
        return telemetryConfiguration;
    }

    private void initializeComponents(TelemetryConfiguration configuration) {
        List telemetryModules = configuration.getTelemetryModules();
        for (TelemetryModule module : telemetryModules) {
            try {
                module.initialize(configuration);
            }
            catch (Exception e) {
                log.error("Failed to initialized telemetry module " + module.getClass().getSimpleName(), (Throwable)e);
            }
        }
    }

    @Bean
    public TelemetryClient telemetryClient(TelemetryConfiguration configuration) {
        return new TelemetryClient(configuration);
    }

    @Bean
    @ConditionalOnMissingBean
    public TelemetryChannel telemetryChannel(TelemetryConfiguration configuration) {
        boolean hasLfEndpoint = StringUtils.isNotBlank(this.environment.getProperty("azure.application-insights.channel.local-forwarder.endpoint-address"));
        boolean hasInprocEndpoint = StringUtils.isNotBlank(this.environment.getProperty("azure.application-insights.channel.in-process.endpoint-address"));
        if (hasLfEndpoint && hasInprocEndpoint) {
            throw new IllegalConfigurationException("SDK cannot have two channels, please either remove Local Forwarder Endpoint, or In Process Endpoint");
        }
        if (hasLfEndpoint) {
            ApplicationInsightsProperties.Channel.LocalForwarder lf = this.applicationInsightsProperties.getChannel().getLocalForwarder();
            LocalForwarderTelemetryChannel channel = new LocalForwarderTelemetryChannel(lf.getEndpointAddress(), false, lf.getMaxTelemetryBufferCapacity(), lf.getFlushIntervalInSeconds());
            configuration.setChannel((TelemetryChannel)channel);
            return channel;
        }
        ApplicationInsightsProperties.Channel.InProcess inProcess = this.applicationInsightsProperties.getChannel().getInProcess();
        InProcessTelemetryChannel channel = StringUtils.isNotEmpty(inProcess.getEndpointAddress()) ? new InProcessTelemetryChannel(inProcess.getEndpointAddress(), String.valueOf(inProcess.getMaxTransmissionStorageFilesCapacityInMb()), inProcess.isDeveloperMode(), inProcess.getMaxTelemetryBufferCapacity(), inProcess.getFlushIntervalInSeconds(), inProcess.isThrottling(), inProcess.getMaxInstantRetry()) : new InProcessTelemetryChannel(configuration, String.valueOf(inProcess.getMaxTransmissionStorageFilesCapacityInMb()), inProcess.isDeveloperMode(), inProcess.getMaxTelemetryBufferCapacity(), inProcess.getFlushIntervalInSeconds(), inProcess.isThrottling(), inProcess.getMaxInstantRetry());
        configuration.setChannel((TelemetryChannel)channel);
        return channel;
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.quick-pulse.enabled"}, havingValue="true", matchIfMissing=true)
    @DependsOn(value={"telemetryConfiguration"})
    public QuickPulse quickPulse(TelemetryConfiguration configuration) {
        String inProcessEndPoint = this.environment.getProperty("azure.application-insights.channel.local-forwarder.endpoint-address");
        if (StringUtils.isNotBlank(inProcessEndPoint)) {
            return QuickPulse.INSTANCE;
        }
        QuickPulse.INSTANCE.initialize(configuration);
        return QuickPulse.INSTANCE;
    }

    @Bean
    public InternalLogger internalLogger() {
        HashMap<String, String> loggerParameters = new HashMap<String, String>();
        ApplicationInsightsProperties.Logger logger = this.applicationInsightsProperties.getLogger();
        loggerParameters.put("Level", logger.getLevel().name());
        loggerParameters.put("UniquePrefix", logger.getUniquePrefix());
        loggerParameters.put("BaseFolderPath", logger.getBaseFolderPath());
        loggerParameters.put("NumberOfFiles", logger.getNumberOfFiles());
        loggerParameters.put("NumberOfTotalSizeInMB", logger.getNumberOfTotalSizeInMB());
        InternalLogger.INSTANCE.initialize(logger.getType().name(), loggerParameters);
        return InternalLogger.INSTANCE;
    }

    private void initializePerformanceCounterContainer() {
        ApplicationInsightsProperties.PerformanceCounter performanceCounter = this.applicationInsightsProperties.getPerformanceCounter();
        PerformanceCounterContainer.INSTANCE.setCollectionFrequencyInSec(performanceCounter.getCollectionFrequencyInSeconds());
        ApplicationInsightsProperties.Jmx jmx = this.applicationInsightsProperties.getJmx();
        if (jmx.getJmxCounters() != null && jmx.getJmxCounters().size() > 0) {
            this.applicationInsightsProperties.processAndLoadJmxCounters(jmx.getJmxCounters());
        }
    }
}

