/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.boot.dependencies.google.common.collect;

import com.microsoft.applicationinsights.boot.dependencies.google.common.annotations.GwtCompatible;
import com.microsoft.applicationinsights.boot.dependencies.google.common.collect.AbstractMapBasedMultiset;
import com.microsoft.applicationinsights.boot.dependencies.google.common.collect.Iterables;
import com.microsoft.applicationinsights.boot.dependencies.google.common.collect.Multisets;
import com.microsoft.applicationinsights.boot.dependencies.google.common.collect.ObjectCountLinkedHashMap;

@GwtCompatible(serializable=true, emulated=true)
public final class LinkedHashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    public static <E> LinkedHashMultiset<E> create() {
        return LinkedHashMultiset.create(3);
    }

    public static <E> LinkedHashMultiset<E> create(int distinctElements) {
        return new LinkedHashMultiset<E>(distinctElements);
    }

    public static <E> LinkedHashMultiset<E> create(Iterable<? extends E> elements) {
        LinkedHashMultiset<E> multiset = LinkedHashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    LinkedHashMultiset(int distinctElements) {
        super(distinctElements);
    }

    @Override
    void init(int distinctElements) {
        this.backingMap = new ObjectCountLinkedHashMap(distinctElements);
    }
}

