/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.AbstractWindowsPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.JniPCConnector;
import com.microsoft.applicationinsights.internal.perfcounter.WindowsPerformanceCounterData;
import com.microsoft.applicationinsights.internal.system.SystemInformation;
import com.microsoft.applicationinsights.telemetry.MetricTelemetry;
import java.util.HashMap;
import java.util.Map;

public final class WindowsPerformanceCounterAsMetric
extends AbstractWindowsPerformanceCounter {
    private static final String ID = "JSDK_WindowsPerformanceCounterAsMetric";
    private final HashMap<String, String> keyToDisplayName = new HashMap();
    private final MetricTelemetry telemetry = new MetricTelemetry();

    public WindowsPerformanceCounterAsMetric(Iterable<WindowsPerformanceCounterData> pcsData) throws Throwable {
        if (!SystemInformation.INSTANCE.isWindows()) {
            throw new IllegalStateException("Must be used under Windows OS.");
        }
        if (pcsData == null) {
            throw new NullPointerException("pcsData must be non-null value.");
        }
        this.telemetry.markAsCustomPerfCounter();
        this.register(pcsData);
        if (this.keyToDisplayName.isEmpty()) {
            throw new Exception("No valid data");
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void report(TelemetryClient telemetryClient) {
        for (Map.Entry<String, String> entry : this.keyToDisplayName.entrySet()) {
            try {
                double value = JniPCConnector.getValueOfPerformanceCounter(entry.getKey());
                if (value < 0.0) {
                    this.reportError(value, entry.getValue());
                    continue;
                }
                this.send(telemetryClient, value, entry.getValue());
                InternalLogger.INSTANCE.trace("Sent metric performance counter for '%s': '%s'", entry.getValue(), value);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable e) {
                try {
                    InternalLogger.INSTANCE.error("Failed to send metric performance counter for '%s': '%s'", entry.getValue(), e.toString());
                    InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    private void register(Iterable<WindowsPerformanceCounterData> pcsData) {
        for (WindowsPerformanceCounterData data : pcsData) {
            try {
                String key = JniPCConnector.addPerformanceCounter(data.getCategoryName(), data.getCounterName(), data.getInstanceName());
                if (StringUtils.isEmpty(key)) continue;
                this.keyToDisplayName.put(key, data.getDisplayName());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    InternalLogger.INSTANCE.trace("error registering %s, Stack trace generated is %s", data.getDisplayName(), ExceptionUtils.getStackTrace(t));
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    protected void send(TelemetryClient telemetryClient, double value, String key) {
        this.telemetry.setName(key);
        this.telemetry.setValue(value);
        telemetryClient.track(this.telemetry);
    }
}

