/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.quickpulse;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Preconditions;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.HttpPost;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSender;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSenderFactory;
import com.microsoft.applicationinsights.internal.quickpulse.DefaultQuickPulseCoordinator;
import com.microsoft.applicationinsights.internal.quickpulse.DefaultQuickPulseDataFetcher;
import com.microsoft.applicationinsights.internal.quickpulse.DefaultQuickPulseDataSender;
import com.microsoft.applicationinsights.internal.quickpulse.DefaultQuickPulsePingSender;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseCoordinatorInitData;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseCoordinatorInitDataBuilder;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataCollector;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataSender;
import com.microsoft.applicationinsights.internal.shutdown.SDKShutdownActivity;
import com.microsoft.applicationinsights.internal.shutdown.Stoppable;
import com.microsoft.applicationinsights.internal.util.DeviceInfo;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public enum QuickPulse implements Stoppable
{
    INSTANCE;

    private volatile boolean initialized = false;
    private Thread thread;
    private Thread senderThread;
    private DefaultQuickPulseCoordinator coordinator;
    private QuickPulseDataSender quickPulseDataSender;

    @Deprecated
    public void initialize() {
        this.initialize(TelemetryConfiguration.getActive());
    }

    public void initialize(final TelemetryConfiguration configuration) {
        Preconditions.checkNotNull(configuration);
        final CountDownLatch latch = new CountDownLatch(1);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                QuickPulse.this.initializeSync(latch, configuration);
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSync(CountDownLatch latch, TelemetryConfiguration configuration) {
        if (this.initialized) {
            latch.countDown();
        } else {
            QuickPulse quickPulse = INSTANCE;
            synchronized (quickPulse) {
                latch.countDown();
                if (!this.initialized) {
                    this.initialized = true;
                    String quickPulseId = UUID.randomUUID().toString().replace("-", "");
                    ApacheSender apacheSender = ApacheSenderFactory.INSTANCE.create();
                    ArrayBlockingQueue<HttpPost> sendQueue = new ArrayBlockingQueue<HttpPost>(256, true);
                    this.quickPulseDataSender = new DefaultQuickPulseDataSender(apacheSender, sendQueue);
                    String instanceName = DeviceInfo.getHostName();
                    if (LocalStringsUtils.isNullOrEmpty(instanceName)) {
                        instanceName = "Unknown host";
                    }
                    DefaultQuickPulsePingSender quickPulsePingSender = new DefaultQuickPulsePingSender(apacheSender, configuration, instanceName, quickPulseId);
                    DefaultQuickPulseDataFetcher quickPulseDataFetcher = new DefaultQuickPulseDataFetcher(sendQueue, configuration, instanceName, quickPulseId);
                    QuickPulseCoordinatorInitData coordinatorInitData = new QuickPulseCoordinatorInitDataBuilder().withPingSender(quickPulsePingSender).withDataFetcher(quickPulseDataFetcher).withDataSender(this.quickPulseDataSender).build();
                    this.coordinator = new DefaultQuickPulseCoordinator(coordinatorInitData);
                    this.senderThread = new Thread((Runnable)this.quickPulseDataSender, QuickPulseDataSender.class.getSimpleName());
                    this.senderThread.setDaemon(true);
                    this.senderThread.start();
                    this.thread = new Thread((Runnable)this.coordinator, DefaultQuickPulseCoordinator.class.getSimpleName());
                    this.thread.setDaemon(true);
                    this.thread.start();
                    SDKShutdownActivity.INSTANCE.register(this);
                    QuickPulseDataCollector.INSTANCE.enable(configuration);
                }
            }
        }
    }

    @Override
    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        if (!this.initialized) {
            return;
        }
        this.coordinator.stop();
        this.quickPulseDataSender.stop();
        this.thread.interrupt();
        this.senderThread.interrupt();
        this.initialized = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.senderThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

