/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.extensibility.modules;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.web.extensibility.modules.WebTelemetryModule;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import com.microsoft.applicationinsights.web.internal.correlation.TelemetryCorrelationUtils;
import com.microsoft.applicationinsights.web.internal.correlation.TraceContextCorrelation;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebRequestTrackingTelemetryModule
implements WebTelemetryModule,
TelemetryModule {
    private TelemetryClient telemetryClient;
    private boolean isInitialized = false;
    public boolean isW3CEnabled = true;
    private final String W3C_CONFIGURATION_PARAMETER = "W3CEnabled";
    private final String W3C_BACKCOMPAT_PARAMETER = "enableW3CBackCompat";

    public WebRequestTrackingTelemetryModule() {
    }

    public WebRequestTrackingTelemetryModule(Map<String, String> configurationData) {
        if (configurationData == null) {
            throw new NullPointerException("configurationData should not be null");
        }
        if (configurationData.containsKey("W3CEnabled")) {
            this.isW3CEnabled = Boolean.valueOf(configurationData.get("W3CEnabled"));
            InternalLogger.INSTANCE.trace(String.format("Inbound W3C tracing mode is enabled %s", this.isW3CEnabled), new Object[0]);
        }
        if (configurationData.containsKey("enableW3CBackCompat")) {
            boolean enableBackCompatibilityForW3C = Boolean.valueOf(configurationData.get("enableW3CBackCompat"));
            TraceContextCorrelation.setIsW3CBackCompatEnabled(enableBackCompatibilityForW3C);
        }
    }

    public void setEnableBackCompatibilityForW3C(boolean enableBackCompatibilityForW3C) {
        TraceContextCorrelation.setIsW3CBackCompatEnabled(enableBackCompatibilityForW3C);
    }

    @Override
    public void onBeginRequest(ServletRequest req, ServletResponse res) {
        if (!this.isInitialized) {
            return;
        }
        try {
            this.resolveCorrelation(req, res);
        }
        catch (Exception e) {
            String moduleClassName = this.getClass().getSimpleName();
            InternalLogger.INSTANCE.error("Telemetry module %s onBeginRequest failed with exception: %s", moduleClassName, e.toString());
        }
    }

    private void resolveCorrelation(ServletRequest req, ServletResponse res) {
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        RequestTelemetryContext context = ThreadContext.getRequestTelemetryContext();
        RequestTelemetry telemetry = context.getHttpRequestTelemetry();
        if (this.isW3CEnabled) {
            TraceContextCorrelation.resolveCorrelation(request, response, telemetry);
        } else {
            TelemetryCorrelationUtils.resolveCorrelation(request, response, telemetry);
        }
    }

    @Override
    public void onEndRequest(ServletRequest req, ServletResponse res) {
        if (!this.isInitialized) {
            return;
        }
        try {
            RequestTelemetry telemetry = ThreadContext.getRequestTelemetryContext().getHttpRequestTelemetry();
            this.resolveRequestSource(req, telemetry);
            this.telemetryClient.track(telemetry);
        }
        catch (Exception e) {
            String moduleClassName = this.getClass().getSimpleName();
            InternalLogger.INSTANCE.error("Telemetry module %s onEndRequest failed with exception: %s", moduleClassName, e.toString());
        }
    }

    private void resolveRequestSource(ServletRequest req, RequestTelemetry telemetry) {
        HttpServletRequest request = (HttpServletRequest)req;
        String instrumentationKey = this.telemetryClient.getContext().getInstrumentationKey();
        if (this.isW3CEnabled) {
            TraceContextCorrelation.resolveRequestSource(request, telemetry, instrumentationKey);
        } else {
            TelemetryCorrelationUtils.resolveRequestSource(request, telemetry, instrumentationKey);
        }
    }

    @Override
    public void initialize(TelemetryConfiguration configuration) {
        try {
            this.telemetryClient = new TelemetryClient(configuration);
            this.isInitialized = true;
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to initialize telemetry module %s. Exception: %s.", this.getClass().getSimpleName(), e.toString());
        }
    }
}

