/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.struts;

import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;

public class RequestNameInterceptor
implements Interceptor {
    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        this.setRequestNameSafe();
        String result = invocation.invoke();
        return result;
    }

    public void destroy() {
    }

    private void setRequestNameSafe() {
        try {
            RequestTelemetryContext context = ThreadContext.getRequestTelemetryContext();
            if (context != null) {
                String actionName = ActionContext.getContext().getName();
                String httpMethod = context.getHttpRequestTelemetry().getHttpMethod();
                String requestName = String.format("%s /%s", httpMethod, actionName);
                context.getHttpRequestTelemetry().setName(requestName);
            }
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to invoke interceptor '%s' with exception: %s.", new Object[]{this.getClass().getSimpleName(), e.getMessage()});
        }
    }
}

