/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.extensibility.modules;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.extensibility.context.UserContext;
import com.microsoft.applicationinsights.web.extensibility.modules.WebTelemetryModule;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import com.microsoft.applicationinsights.web.internal.cookies.Cookie;
import com.microsoft.applicationinsights.web.internal.cookies.UserCookie;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class WebUserTrackingTelemetryModule
implements WebTelemetryModule,
TelemetryModule {
    public void initialize(TelemetryConfiguration configuration) {
    }

    @Override
    public void onBeginRequest(ServletRequest req, ServletResponse res) {
        HttpServletRequest request = (HttpServletRequest)req;
        RequestTelemetryContext context = ThreadContext.getRequestTelemetryContext();
        UserCookie userCookie = Cookie.getCookie(UserCookie.class, request, "ai_user");
        if (userCookie == null) {
            return;
        }
        String userId = userCookie.getUserId();
        Date acquisitionDate = userCookie.getAcquisitionDate();
        context.setUserCookie(userCookie);
        UserContext userContext = context.getHttpRequestTelemetry().getContext().getUser();
        userContext.setId(userId);
        userContext.setAcquisitionDate(acquisitionDate);
    }

    @Override
    public void onEndRequest(ServletRequest req, ServletResponse res) {
    }
}

