/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Preconditions;
import com.microsoft.applicationinsights.internal.channel.TelemetriesTransmitter;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LimitsEnforcer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class TelemetryBuffer {
    private final TelemetriesTransmitter sender;
    private int maxTelemetriesInBatch;
    private LimitsEnforcer maxTelemetriesInBatchEnforcer;
    private int transmitBufferTimeoutInSeconds;
    private LimitsEnforcer transmitBufferTimeoutInSecondsEnforcer;
    private List<String> telemetries;
    private long generation = 0L;
    private final Object lock = new Object();

    public TelemetryBuffer(TelemetriesTransmitter sender, LimitsEnforcer maxTelemetriesInBatchEnforcer, LimitsEnforcer transmitBufferTimeoutInSecondsEnforcer) {
        Preconditions.checkNotNull(sender, "sender must be non-null value");
        Preconditions.checkNotNull(maxTelemetriesInBatchEnforcer, "maxTelemetriesInBatchEnforcer must be non-null value");
        Preconditions.checkNotNull(transmitBufferTimeoutInSecondsEnforcer, "transmitBufferTimeoutInSecondsEnforcer must be non-null value");
        Preconditions.checkArgument(maxTelemetriesInBatchEnforcer.getCurrentValue() > 0, "maxTelemetriesInBatch must be a positive number");
        Preconditions.checkArgument(transmitBufferTimeoutInSecondsEnforcer.getCurrentValue() > 0, "transmitBufferTimeoutInSeconds must be a positive number");
        this.maxTelemetriesInBatchEnforcer = maxTelemetriesInBatchEnforcer;
        this.maxTelemetriesInBatch = maxTelemetriesInBatchEnforcer.getCurrentValue();
        this.telemetries = new ArrayList<String>(this.maxTelemetriesInBatch);
        this.sender = sender;
        this.transmitBufferTimeoutInSecondsEnforcer = transmitBufferTimeoutInSecondsEnforcer;
        this.transmitBufferTimeoutInSeconds = transmitBufferTimeoutInSecondsEnforcer.getCurrentValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxTelemetriesInBatch(int value) {
        Object object = this.lock;
        synchronized (object) {
            this.maxTelemetriesInBatch = this.maxTelemetriesInBatchEnforcer.normalizeValue(value);
            if (this.telemetries != null && this.maxTelemetriesInBatch < this.telemetries.size()) {
                this.flush();
            }
        }
    }

    public int getMaxTelemetriesInBatch() {
        return this.maxTelemetriesInBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransmitBufferTimeoutInSeconds(int value) {
        Object object = this.lock;
        synchronized (object) {
            int oldValue = this.transmitBufferTimeoutInSeconds;
            this.transmitBufferTimeoutInSeconds = this.transmitBufferTimeoutInSecondsEnforcer.normalizeValue(value);
            if (this.transmitBufferTimeoutInSeconds < oldValue) {
                this.flush();
            }
        }
    }

    public int getTransmitBufferTimeoutInSeconds() {
        return this.transmitBufferTimeoutInSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String telemetry) {
        Preconditions.checkNotNull(telemetry, "Telemetry must be non null value");
        Object object = this.lock;
        synchronized (object) {
            this.telemetries.add(telemetry);
            int currentSize = this.telemetries.size();
            if (currentSize >= this.maxTelemetriesInBatch) {
                if (!this.sender.sendNow(this.prepareTelemetriesForSend())) {
                    InternalLogger.INSTANCE.error("Failed to send buffer data to network", new Object[0]);
                }
            } else if (currentSize == 1 && !this.sender.scheduleSend(new TelemetryBufferTelemetriesFetcher(this.generation), this.transmitBufferTimeoutInSeconds, TimeUnit.SECONDS)) {
                InternalLogger.INSTANCE.error("Failed to schedule send of the buffer to network", new Object[0]);
                this.telemetries.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.telemetries.size() != 0 && !this.sender.sendNow(this.prepareTelemetriesForSend())) {
                InternalLogger.INSTANCE.error("Failed to flush buffer data to network", new Object[0]);
            }
        }
    }

    private List<String> prepareTelemetriesForSend() {
        ++this.generation;
        List<String> readyToBeSent = this.telemetries;
        this.telemetries = new ArrayList<String>(this.maxTelemetriesInBatch);
        return readyToBeSent;
    }

    private final class TelemetryBufferTelemetriesFetcher
    implements TelemetriesTransmitter.TelemetriesFetcher {
        private final long expectedGeneration;

        private TelemetryBufferTelemetriesFetcher(long expectedGeneration) {
            this.expectedGeneration = expectedGeneration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<String> fetch() {
            Object object = TelemetryBuffer.this.lock;
            synchronized (object) {
                if (this.expectedGeneration != TelemetryBuffer.this.generation) {
                    return Collections.emptyList();
                }
                ++TelemetryBuffer.this.generation;
                List readyToBeSent = TelemetryBuffer.this.telemetries;
                TelemetryBuffer.this.telemetries = new ArrayList();
                return readyToBeSent;
            }
        }
    }
}

