/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Preconditions;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.AbstractPerformanceCounter;
import com.microsoft.applicationinsights.internal.system.SystemInformation;
import java.io.File;

abstract class AbstractUnixPerformanceCounter
extends AbstractPerformanceCounter {
    private final File processFile;
    private final String path;

    protected AbstractUnixPerformanceCounter(String path) {
        Preconditions.checkArgument(SystemInformation.INSTANCE.isUnix(), "This performance counter must be activated in Unix environment.");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(path), "path should be non null, non empty value.");
        this.path = path;
        this.processFile = new File(path);
        if (!this.processFile.canRead()) {
            this.logPerfCounterErrorError("Can not read", new Object[0]);
        }
    }

    protected void logPerfCounterErrorError(String format, Object ... args) {
        format = "Performance Counter " + this.getId() + ": Error in file '" + this.path + "': " + format;
        InternalLogger.INSTANCE.error(format, args);
    }

    protected File getProcessFile() {
        return this.processFile;
    }
}

