/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.correlation;

import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.shutdown.SDKShutdownActivity;
import com.microsoft.applicationinsights.web.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.web.dependencies.http.ParseException;
import com.microsoft.applicationinsights.web.dependencies.http.client.config.RequestConfig;
import com.microsoft.applicationinsights.web.dependencies.http.client.methods.HttpGet;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.CloseableHttpAsyncClient;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.HttpAsyncClients;
import com.microsoft.applicationinsights.web.dependencies.http.util.EntityUtils;
import com.microsoft.applicationinsights.web.internal.correlation.AppProfileFetcher;
import com.microsoft.applicationinsights.web.internal.correlation.ProfileFetcherResult;
import com.microsoft.applicationinsights.web.internal.correlation.ProfileFetcherResultTaskStatus;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class CdsProfileFetcher
implements AppProfileFetcher {
    private CloseableHttpAsyncClient httpClient;
    private String endpointAddress;
    private static final String ProfileQueryEndpointAppIdFormat = "%s/api/profiles/%s/appId";
    private static final String DefaultProfileQueryEndpointAddress = "https://dc.services.visualstudio.com";
    private static final int MAX_RETRIES = 3;
    private final ConcurrentMap<String, Future<HttpResponse>> tasks;
    private final Map<String, Integer> failureCounters;

    public CdsProfileFetcher() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).build();
        this.setHttpClient(HttpAsyncClients.custom().setDefaultRequestConfig(requestConfig).useSystemProperties().build());
        this.httpClient.start();
        this.tasks = new ConcurrentHashMap<String, Future<HttpResponse>>();
        this.failureCounters = new HashMap<String, Integer>();
        this.endpointAddress = DefaultProfileQueryEndpointAddress;
    }

    @Override
    public ProfileFetcherResult fetchAppProfile(String instrumentationKey) throws InterruptedException, ExecutionException, ParseException, IOException {
        if (instrumentationKey == null || instrumentationKey.isEmpty()) {
            throw new IllegalArgumentException("instrumentationKey must be not null or empty");
        }
        ProfileFetcherResult result = new ProfileFetcherResult(null, ProfileFetcherResultTaskStatus.PENDING);
        Integer failureCounter = this.failureCounters.get(instrumentationKey);
        if (failureCounter != null && failureCounter >= 3) {
            InternalLogger.INSTANCE.warn("The profile fetch task will not execute. Max number of retries reached.", new Object[0]);
            return result;
        }
        Future<HttpResponse> currentTask = (Future<HttpResponse>)this.tasks.get(instrumentationKey);
        if (currentTask == null) {
            currentTask = this.createFetchTask(instrumentationKey);
            this.tasks.putIfAbsent(instrumentationKey, currentTask);
        }
        if (!currentTask.isDone()) {
            return result;
        }
        try {
            HttpResponse response = currentTask.get();
            if (response.getStatusLine().getStatusCode() != 200) {
                this.incrementFailureCount(instrumentationKey);
                ProfileFetcherResult profileFetcherResult = new ProfileFetcherResult(null, ProfileFetcherResultTaskStatus.FAILED);
                return profileFetcherResult;
            }
            String appId = EntityUtils.toString(response.getEntity());
            if (appId == null || appId.isEmpty()) {
                this.incrementFailureCount(instrumentationKey);
                ProfileFetcherResult profileFetcherResult = new ProfileFetcherResult(null, ProfileFetcherResultTaskStatus.FAILED);
                return profileFetcherResult;
            }
            ProfileFetcherResult profileFetcherResult = new ProfileFetcherResult(appId, ProfileFetcherResultTaskStatus.COMPLETE);
            return profileFetcherResult;
        }
        catch (Exception ex) {
            this.incrementFailureCount(instrumentationKey);
            throw ex;
        }
        finally {
            this.tasks.remove(instrumentationKey);
        }
    }

    public void setHttpClient(CloseableHttpAsyncClient client) {
        this.httpClient = client;
        SDKShutdownActivity.INSTANCE.register(this.httpClient);
    }

    public void setEndpointAddress(String endpoint) throws MalformedURLException {
        URL url = new URL(endpoint);
        String urlStr = url.toString();
        this.endpointAddress = urlStr.substring(0, urlStr.length() - url.getFile().length());
    }

    private Future<HttpResponse> createFetchTask(String instrumentationKey) {
        HttpGet request = new HttpGet(String.format(ProfileQueryEndpointAppIdFormat, this.endpointAddress, instrumentationKey));
        return this.httpClient.execute(request, null);
    }

    private synchronized void incrementFailureCount(String instrumentationKey) {
        Integer failureCounter = this.failureCounters.get(instrumentationKey);
        if (failureCounter == null) {
            this.failureCounters.put(instrumentationKey, new Integer(1));
        } else {
            this.failureCounters.put(instrumentationKey, new Integer(failureCounter + 1));
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

