/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.quickpulse;

import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseCoordinatorInitData;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataFetcher;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataSender;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulsePingSender;

final class QuickPulseCoordinatorInitDataBuilder {
    private static final long DEFAULT_WAIT_BETWEEN_PING_IN_MS = 5000L;
    private static final long DEFAULT_WAIT_BETWEEN_POSTS_IN_MS = 1000L;
    private static final long DEFAULT_WAIT_BETWEEN_PINGS_AFTER_ERROR_IN_MS = 60000L;
    private QuickPulsePingSender pingSender;
    private QuickPulseDataSender dataSender;
    private QuickPulseDataFetcher dataFetcher;
    private long waitBetweenPingsInMS = 5000L;
    private long waitBetweenPostsInMS = 1000L;
    private long waitOnErrorInMS = 60000L;

    QuickPulseCoordinatorInitDataBuilder() {
    }

    public QuickPulseCoordinatorInitDataBuilder withWaitBetweenPingsInMS(long waitBetweenPingsInMS) {
        this.waitBetweenPingsInMS = waitBetweenPingsInMS;
        return this;
    }

    public QuickPulseCoordinatorInitDataBuilder withWaitBetweenPostsInMS(long waitBetweenPostsInMS) {
        this.waitBetweenPostsInMS = waitBetweenPostsInMS;
        return this;
    }

    public QuickPulseCoordinatorInitDataBuilder withWaitOnErrorInMS(long waitOnErrorInMS) {
        this.waitOnErrorInMS = waitOnErrorInMS;
        return this;
    }

    public QuickPulseCoordinatorInitDataBuilder withPingSender(QuickPulsePingSender pingSender) {
        this.pingSender = pingSender;
        return this;
    }

    public QuickPulseCoordinatorInitDataBuilder withDataSender(QuickPulseDataSender dataSender) {
        this.dataSender = dataSender;
        return this;
    }

    public QuickPulseCoordinatorInitDataBuilder withDataFetcher(QuickPulseDataFetcher dataFetcher) {
        this.dataFetcher = dataFetcher;
        return this;
    }

    public QuickPulseCoordinatorInitData build() {
        if (this.pingSender == null) {
            throw new NullPointerException("ping sender should not be null");
        }
        if (this.dataFetcher == null) {
            throw new NullPointerException("data fetcher should not be null");
        }
        if (this.dataSender == null) {
            throw new NullPointerException("data sender should not be null");
        }
        return new QuickPulseCoordinatorInitData(this.pingSender, this.dataFetcher, this.dataSender, this.waitBetweenPingsInMS, this.waitBetweenPostsInMS, this.waitOnErrorInMS);
    }
}

