/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.heartbeat;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatProvider;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatProviderInterface;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class HeartBeatModule
implements TelemetryModule {
    private final HeartBeatProviderInterface heartBeatProviderInterface;
    private final Object lock = new Object();
    private static volatile boolean isInitialized = false;

    public HeartBeatModule() {
        this.heartBeatProviderInterface = new HeartBeatProvider();
    }

    public HeartBeatModule(Map<String, String> properties) {
        this.heartBeatProviderInterface = new HeartBeatProvider();
        if (properties != null) {
            block20: for (Map.Entry<String, String> entry : properties.entrySet()) {
                switch (entry.getKey()) {
                    case "HeartBeatInterval": {
                        try {
                            this.setHeartBeatInterval(Long.parseLong(entry.getValue()));
                        }
                        catch (Exception e) {
                            if (!InternalLogger.INSTANCE.isTraceEnabled()) continue block20;
                            InternalLogger.INSTANCE.trace("Exception while adding Heartbeat interval: %s", ExceptionUtils.getStackTrace(e));
                        }
                        break;
                    }
                    case "isHeartBeatEnabled": {
                        try {
                            this.setHeartBeatEnabled(Boolean.parseBoolean(entry.getValue()));
                        }
                        catch (Exception e) {
                            if (!InternalLogger.INSTANCE.isTraceEnabled()) continue block20;
                            InternalLogger.INSTANCE.trace("Exception while adding enabling/disabling heartbeat: %s", ExceptionUtils.getStackTrace(e));
                        }
                        break;
                    }
                    case "ExcludedHeartBeatPropertiesProvider": {
                        try {
                            List<String> excludedHeartBeatPropertiesProviderList = this.parseStringToList(entry.getValue());
                            this.setExcludedHeartBeatPropertiesProvider(excludedHeartBeatPropertiesProviderList);
                        }
                        catch (Exception e) {
                            if (!InternalLogger.INSTANCE.isTraceEnabled()) continue block20;
                            InternalLogger.INSTANCE.trace("Exception while adding Excluded Heartbeat providers: %s", ExceptionUtils.getStackTrace(e));
                        }
                        break;
                    }
                    case "ExcludedHeartBeatProperties": {
                        try {
                            List<String> excludedHeartBeatPropertiesList = this.parseStringToList(entry.getValue());
                            this.setExcludedHeartBeatProperties(excludedHeartBeatPropertiesList);
                        }
                        catch (Exception e) {
                            if (!InternalLogger.INSTANCE.isTraceEnabled()) continue block20;
                            InternalLogger.INSTANCE.trace("Exception while adding excluded heartbeat properties: %s", ExceptionUtils.getStackTrace(e));
                        }
                        break;
                    }
                    default: {
                        InternalLogger.INSTANCE.trace("Encountered unknown parameter, no action will be performed", new Object[0]);
                    }
                }
            }
        }
    }

    public long getHeartBeatInterval() {
        return this.heartBeatProviderInterface.getHeartBeatInterval();
    }

    public void setHeartBeatInterval(long heartBeatInterval) {
        this.heartBeatProviderInterface.setHeartBeatInterval(heartBeatInterval);
    }

    public List<String> getExcludedHeartBeatProperties() {
        return this.heartBeatProviderInterface.getExcludedHeartBeatProperties();
    }

    public void setExcludedHeartBeatProperties(List<String> excludedHeartBeatProperties) {
        this.heartBeatProviderInterface.setExcludedHeartBeatProperties(excludedHeartBeatProperties);
    }

    public List<String> getExcludedHeartBeatPropertiesProvider() {
        return this.heartBeatProviderInterface.getExcludedHeartBeatPropertyProviders();
    }

    public void setExcludedHeartBeatPropertiesProvider(List<String> excludedHeartBeatPropertiesProvider) {
        this.heartBeatProviderInterface.setExcludedHeartBeatPropertyProviders(excludedHeartBeatPropertiesProvider);
    }

    public boolean isHeartBeatEnabled() {
        return this.heartBeatProviderInterface.isHeartBeatEnabled();
    }

    public void setHeartBeatEnabled(boolean heartBeatEnabled) {
        this.heartBeatProviderInterface.setHeartBeatEnabled(heartBeatEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(TelemetryConfiguration configuration) {
        if (!isInitialized && this.isHeartBeatEnabled()) {
            Object object = this.lock;
            synchronized (object) {
                if (!isInitialized && this.isHeartBeatEnabled()) {
                    this.heartBeatProviderInterface.initialize(configuration);
                    InternalLogger.INSTANCE.info("heartbeat is enabled", new Object[0]);
                    isInitialized = true;
                }
            }
        }
    }

    private List<String> parseStringToList(String value) {
        if (value == null || value.length() == 0) {
            return new ArrayList<String>();
        }
        return Arrays.asList(value.split(";"));
    }
}

