/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.correlation;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.shutdown.SDKShutdownActivity;
import com.microsoft.applicationinsights.internal.util.PeriodicTaskPool;
import com.microsoft.applicationinsights.internal.util.SSLOptionsUtil;
import com.microsoft.applicationinsights.web.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.web.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.web.dependencies.http.client.config.RequestConfig;
import com.microsoft.applicationinsights.web.dependencies.http.client.methods.HttpGet;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.CloseableHttpAsyncClient;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.HttpAsyncClients;
import com.microsoft.applicationinsights.web.dependencies.http.nio.conn.ssl.SSLIOSessionStrategy;
import com.microsoft.applicationinsights.web.dependencies.http.ssl.SSLContexts;
import com.microsoft.applicationinsights.web.dependencies.http.util.EntityUtils;
import com.microsoft.applicationinsights.web.internal.correlation.AppProfileFetcher;
import com.microsoft.applicationinsights.web.internal.correlation.ApplicationIdResolutionException;
import com.microsoft.applicationinsights.web.internal.correlation.ApplicationIdResolver;
import com.microsoft.applicationinsights.web.internal.correlation.ProfileFetcherResult;
import com.microsoft.applicationinsights.web.internal.correlation.ProfileFetcherResultTaskStatus;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CdsProfileFetcher
implements AppProfileFetcher,
ApplicationIdResolver {
    private CloseableHttpAsyncClient httpClient;
    private String endpointAddress = null;
    private static final String PROFILE_QUERY_ENDPOINT_APP_ID_FORMAT = "%s/api/profiles/%s/appId";
    final ConcurrentMap<String, Future<HttpResponse>> tasks;
    final ConcurrentMap<String, Integer> failureCounters;
    private final PeriodicTaskPool taskThreadPool = new PeriodicTaskPool(1, CdsProfileFetcher.class.getSimpleName());
    private final CdsRetryPolicy retryPolicy;

    public CdsProfileFetcher() {
        this(new CdsRetryPolicy());
    }

    public CdsProfileFetcher(CdsRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).build();
        String[] allowedProtocols = SSLOptionsUtil.getAllowedProtocols();
        this.setHttpClient(HttpAsyncClients.custom().setDefaultRequestConfig(requestConfig).setSSLStrategy(new SSLIOSessionStrategy(SSLContexts.createDefault(), allowedProtocols, null, SSLIOSessionStrategy.getDefaultHostnameVerifier())).useSystemProperties().build());
        long resetInterval = retryPolicy.getResetPeriodInMinutes();
        PeriodicTaskPool.PeriodicRunnableTask cdsRetryClearTask = PeriodicTaskPool.PeriodicRunnableTask.createTask(new CachePurgingRunnable(), resetInterval, resetInterval, TimeUnit.MINUTES, "cdsRetryClearTask");
        this.tasks = new ConcurrentHashMap<String, Future<HttpResponse>>();
        this.failureCounters = new ConcurrentHashMap<String, Integer>();
        this.taskThreadPool.executePeriodicRunnableTask(cdsRetryClearTask);
        this.httpClient.start();
        SDKShutdownActivity.INSTANCE.register(this);
    }

    @Override
    @Deprecated
    public ProfileFetcherResult fetchAppProfile(String instrumentationKey) throws InterruptedException, ExecutionException, IOException {
        return this.internalFetchAppProfile(instrumentationKey, TelemetryConfiguration.getActive());
    }

    @Override
    public ProfileFetcherResult fetchApplicationId(String instrumentationKey, TelemetryConfiguration configuration) throws ApplicationIdResolutionException, InterruptedException {
        try {
            return this.internalFetchAppProfile(instrumentationKey, configuration);
        }
        catch (IOException | ExecutionException e) {
            throw new ApplicationIdResolutionException(e);
        }
    }

    private ProfileFetcherResult internalFetchAppProfile(String instrumentationKey, TelemetryConfiguration configuration) throws InterruptedException, ExecutionException, IOException {
        Future<HttpResponse> mapValue;
        if (StringUtils.isEmpty(instrumentationKey)) {
            throw new IllegalArgumentException("instrumentationKey must not be null or empty");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        ProfileFetcherResult result = new ProfileFetcherResult(null, ProfileFetcherResultTaskStatus.PENDING);
        if (this.failureCounters.containsKey(instrumentationKey) && (Integer)this.failureCounters.get(instrumentationKey) >= this.retryPolicy.getMaxInstantRetries()) {
            InternalLogger.INSTANCE.info("The profile fetch task will not execute for next %d minutes. Max number of retries reached.", this.retryPolicy.getResetPeriodInMinutes());
            return result;
        }
        Future<HttpResponse> currentTask = (Future<HttpResponse>)this.tasks.get(instrumentationKey);
        if (currentTask == null && (mapValue = this.tasks.putIfAbsent(instrumentationKey, currentTask = this.createFetchTask(instrumentationKey, configuration))) != null) {
            currentTask = mapValue;
        }
        if (!currentTask.isDone()) {
            return result;
        }
        try {
            HttpResponse response = currentTask.get();
            if (response.getStatusLine().getStatusCode() != 200) {
                this.incrementFailureCount(instrumentationKey);
                ProfileFetcherResult profileFetcherResult = new ProfileFetcherResult(null, ProfileFetcherResultTaskStatus.FAILED);
                return profileFetcherResult;
            }
            String appId = EntityUtils.toString(response.getEntity());
            if (appId == null || appId.isEmpty()) {
                this.incrementFailureCount(instrumentationKey);
                ProfileFetcherResult profileFetcherResult = new ProfileFetcherResult(null, ProfileFetcherResultTaskStatus.FAILED);
                return profileFetcherResult;
            }
            ProfileFetcherResult profileFetcherResult = new ProfileFetcherResult(appId, ProfileFetcherResultTaskStatus.COMPLETE);
            return profileFetcherResult;
        }
        catch (Exception ex) {
            this.incrementFailureCount(instrumentationKey);
            throw ex;
        }
        finally {
            this.tasks.remove(instrumentationKey);
        }
    }

    void setHttpClient(CloseableHttpAsyncClient client) {
        this.httpClient = client;
    }

    @Deprecated
    public void setEndpointAddress(String endpoint) throws MalformedURLException {
        URL url = new URL(endpoint);
        String urlStr = url.toString();
        this.endpointAddress = urlStr.substring(0, urlStr.length() - url.getFile().length());
        if (InternalLogger.INSTANCE.isTraceEnabled()) {
            InternalLogger.INSTANCE.trace("%s endpoint override: %s", CdsProfileFetcher.class.getSimpleName(), this.endpointAddress);
        }
    }

    private Future<HttpResponse> createFetchTask(String instrumentationKey, TelemetryConfiguration configuration) {
        HttpGet request = this.endpointAddress == null ? new HttpGet(configuration.getEndpointProvider().getAppIdEndpointURL(instrumentationKey)) : new HttpGet(String.format(PROFILE_QUERY_ENDPOINT_APP_ID_FORMAT, this.endpointAddress, instrumentationKey));
        return this.httpClient.execute(request, null);
    }

    private void incrementFailureCount(String instrumentationKey) {
        if (!this.failureCounters.containsKey(instrumentationKey)) {
            this.failureCounters.put(instrumentationKey, 0);
        }
        this.failureCounters.put(instrumentationKey, (Integer)this.failureCounters.get(instrumentationKey) + 1);
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
        this.taskThreadPool.stop(5L, TimeUnit.SECONDS);
    }

    public static class CdsRetryPolicy {
        public static final int DEFAULT_MAX_INSTANT_RETRIES = 3;
        public static final int DEFAULT_RESET_PERIOD_IN_MINUTES = 240;
        private int maxInstantRetries = 3;
        private long resetPeriodInMinutes = 240L;

        public int getMaxInstantRetries() {
            return this.maxInstantRetries;
        }

        public long getResetPeriodInMinutes() {
            return this.resetPeriodInMinutes;
        }

        public void setMaxInstantRetries(int maxInstantRetries) {
            if (maxInstantRetries < 1) {
                throw new IllegalArgumentException("CDS maxInstantRetries should be at least 1");
            }
            this.maxInstantRetries = maxInstantRetries;
        }

        public void setResetPeriodInMinutes(long resetPeriodInMinutes) {
            if (resetPeriodInMinutes < 1L) {
                throw new IllegalArgumentException("CDS retries reset interval should be at least 1 minute");
            }
            this.resetPeriodInMinutes = resetPeriodInMinutes;
        }
    }

    private class CachePurgingRunnable
    implements Runnable {
        private CachePurgingRunnable() {
        }

        @Override
        public void run() {
            CdsProfileFetcher.this.tasks.clear();
            CdsProfileFetcher.this.failureCounters.clear();
        }
    }
}

