/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.correlation.tracecontext;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Tracestate {
    private static final String KEY_WITHOUT_VENDOR_FORMAT = "[a-z][_0-9a-z\\-\\*\\/]{0,255}";
    private static final String KEY_WITH_VENDOR_FORMAT = "[a-z][_0-9a-z\\-\\*\\/]{0,240}@[a-z][_0-9a-z\\-\\*\\/]{0,13}";
    private static final String KEY_FORMAT = "[a-z][_0-9a-z\\-\\*\\/]{0,255}|[a-z][_0-9a-z\\-\\*\\/]{0,240}@[a-z][_0-9a-z\\-\\*\\/]{0,13}";
    private static final String VALUE_FORMAT = "[\\x20-\\x2b\\x2d-\\x3c\\x3e-\\x7e]{0,255}[\\x21-\\x2b\\x2d-\\x3c\\x3e-\\x7e]";
    private static final String DELIMITER_FORMAT = "[ \\t]*,[ \\t]*";
    private static final String MEMBER_FORMAT = String.format(Locale.ROOT, "(%s)(=)(%s)", "[a-z][_0-9a-z\\-\\*\\/]{0,255}|[a-z][_0-9a-z\\-\\*\\/]{0,240}@[a-z][_0-9a-z\\-\\*\\/]{0,13}", "[\\x20-\\x2b\\x2d-\\x3c\\x3e-\\x7e]{0,255}[\\x21-\\x2b\\x2d-\\x3c\\x3e-\\x7e]");
    private static final Pattern DELIMITER_FORMAT_RE = Pattern.compile("[ \\t]*,[ \\t]*");
    private static final Pattern MEMBER_FORMAT_RE = Pattern.compile("^" + MEMBER_FORMAT + "$");
    private static final int MAX_KEY_VALUE_PAIRS = 32;
    private final LinkedHashMap<String, String> internalList = new LinkedHashMap(32);
    private final String internalString;

    public Tracestate(String input) {
        String[] values;
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        for (String item : values = DELIMITER_FORMAT_RE.split(input)) {
            Matcher m = MEMBER_FORMAT_RE.matcher(item);
            if (!m.find()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "invalid string %s in tracestate", item));
            }
            String key = m.group(1);
            String value = m.group(3);
            if (this.internalList.get(key) != null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "duplicated keys %s in tracestate", key));
            }
            this.internalList.put(key, value);
        }
        if (this.internalList.size() > 32) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot have more than %d key-value pairs", 32));
        }
        this.internalString = this.toInternalString();
    }

    public String get(String key) {
        return this.internalList.get(key);
    }

    public String toString() {
        return this.internalString;
    }

    private String toInternalString() {
        boolean isFirst = true;
        StringBuilder stringBuilder = new StringBuilder(512);
        for (Map.Entry<String, String> entry : this.internalList.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }
}

