/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.apigeneration;

import com.microsoft.azure.management.apigeneration.Beta;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.microsoft.azure.management.apigeneration.LangDefinition", "com.microsoft.azure.management.apigeneration.Fluent", "com.microsoft.azure.management.apigeneration.Preview"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class LangDefinitionProcessor
extends AbstractProcessor {
    private AbstractProcessor innerProcessor;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        try {
            Class<AbstractProcessor> clz = AbstractProcessor.class;
            Object clzObj = LangDefinitionProcessor.class.getClassLoader().loadClass("com.microsoft.azure.management.apigeneration.LangProcessor").newInstance();
            this.innerProcessor = (AbstractProcessor)clz.cast(clzObj);
            this.innerProcessor.init(processingEnv);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.innerProcessor = null;
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        this.processBeta(roundEnv);
        if (this.innerProcessor != null) {
            return this.innerProcessor.process(annotations, roundEnv);
        }
        return true;
    }

    private void processBeta(RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Beta.class);
        for (Element element : elements) {
            StringBuilder info = new StringBuilder().append("@Beta: ").append(element.getSimpleName()).append(" - ").append(element.getAnnotation(Beta.class).warningText());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, info.toString());
        }
    }
}

