/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.io.CharStreams;
import com.microsoft.azure.arm.core.NetworkCallRecord;
import com.microsoft.azure.arm.core.RecordedData;
import com.microsoft.azure.arm.core.TestBase;
import com.microsoft.azure.arm.core.TestDelayProvider;
import com.microsoft.azure.arm.core.TestResourceNamerFactory;
import com.microsoft.azure.arm.utils.DelayProvider;
import com.microsoft.azure.arm.utils.ResourceNamerFactory;
import com.microsoft.azure.arm.utils.SdkContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSource;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class InterceptorManager {
    private static final String RECORD_FOLDER = "session-records/";
    private static final String BODY_LOGGING = "x-ms-body-logging";
    private Map<String, String> textReplacementRules = new HashMap<String, String>();
    protected RecordedData recordedData;
    private final String testName;
    private final TestBase.TestMode testMode;

    private InterceptorManager(String testName, TestBase.TestMode testMode) {
        this.testName = testName;
        this.testMode = testMode;
    }

    public void addTextReplacementRule(String regex, String replacement) {
        this.textReplacementRules.put(regex, replacement);
    }

    public static InterceptorManager create(String testName, TestBase.TestMode testMode) throws IOException {
        InterceptorManager interceptorManager = new InterceptorManager(testName, testMode);
        SdkContext.setResourceNamerFactory((ResourceNamerFactory)new TestResourceNamerFactory(interceptorManager));
        SdkContext.setDelayProvider((DelayProvider)new TestDelayProvider(interceptorManager.isRecordMode() || interceptorManager.isNoneMode()));
        if (!interceptorManager.isNoneMode()) {
            SdkContext.setRxScheduler((Scheduler)Schedulers.trampoline());
        }
        return interceptorManager;
    }

    public boolean isRecordMode() {
        return this.testMode == TestBase.TestMode.RECORD;
    }

    public boolean isNoneMode() {
        return this.testMode == TestBase.TestMode.NONE;
    }

    public boolean isPlaybackMode() {
        return this.testMode == TestBase.TestMode.PLAYBACK;
    }

    public Interceptor initInterceptor() throws IOException {
        switch (this.testMode) {
            case RECORD: {
                this.recordedData = new RecordedData();
                return new Interceptor(){

                    public Response intercept(Interceptor.Chain chain) throws IOException {
                        return InterceptorManager.this.record(chain);
                    }
                };
            }
            case PLAYBACK: {
                this.readDataFromFile();
                return new Interceptor(){

                    public Response intercept(Interceptor.Chain chain) throws IOException {
                        return InterceptorManager.this.playback(chain);
                    }
                };
            }
            case NONE: {
                System.out.println("==> No interceptor defined for AZURE_TEST_MODE: " + (Object)((Object)this.testMode));
                break;
            }
            default: {
                System.out.println("==> Unknown AZURE_TEST_MODE: " + (Object)((Object)this.testMode));
            }
        }
        return null;
    }

    public void finalizeInterceptor() throws IOException {
        switch (this.testMode) {
            case RECORD: {
                this.writeDataToFile();
                break;
            }
            case PLAYBACK: 
            case NONE: {
                break;
            }
            default: {
                System.out.println("==> Unknown AZURE_TEST_MODE: " + (Object)((Object)this.testMode));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response record(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        NetworkCallRecord networkCallRecord = new NetworkCallRecord();
        networkCallRecord.Headers = new HashMap<String, String>();
        if (request.header("Content-Type") != null) {
            networkCallRecord.Headers.put("Content-Type", request.header("Content-Type"));
        }
        if (request.header("x-ms-version") != null) {
            networkCallRecord.Headers.put("x-ms-version", request.header("x-ms-version"));
        }
        if (request.header("User-Agent") != null) {
            networkCallRecord.Headers.put("User-Agent", request.header("User-Agent"));
        }
        networkCallRecord.Method = request.method();
        networkCallRecord.Uri = this.applyReplacementRule(request.url().toString().replaceAll("\\?$", ""));
        Response response = chain.proceed(request);
        networkCallRecord.Response = new HashMap<String, String>();
        networkCallRecord.Response.put("StatusCode", Integer.toString(response.code()));
        this.extractResponseData(networkCallRecord.Response, response);
        if (!(networkCallRecord.Response.containsKey("Body") && networkCallRecord.Response.get("Body").contains("<Status>InProgress</Status>") || Integer.parseInt(networkCallRecord.Response.get("StatusCode")) == 307)) {
            LinkedList<NetworkCallRecord> linkedList = this.recordedData.getNetworkCallRecords();
            synchronized (linkedList) {
                this.recordedData.getNetworkCallRecords().add(networkCallRecord);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Response playback(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String incomingUrl = this.applyReplacementRule(request.url().toString());
        String incomingMethod = request.method();
        incomingUrl = this.removeHost(incomingUrl);
        NetworkCallRecord networkCallRecord = null;
        RecordedData recordedData = this.recordedData;
        synchronized (recordedData) {
            Iterator iterator = this.recordedData.getNetworkCallRecords().iterator();
            while (iterator.hasNext()) {
                NetworkCallRecord record = (NetworkCallRecord)iterator.next();
                if (!record.Method.equalsIgnoreCase(incomingMethod) || !this.removeHost(record.Uri).equalsIgnoreCase(incomingUrl)) continue;
                networkCallRecord = record;
                iterator.remove();
                break;
            }
        }
        if (networkCallRecord == null) {
            System.out.println("NOT FOUND - " + incomingMethod + " " + incomingUrl);
            System.out.println("Remaining records " + this.recordedData.getNetworkCallRecords().size());
            throw new IOException("==> Unexpected request: " + incomingMethod + " " + incomingUrl);
        }
        int recordStatusCode = Integer.parseInt(networkCallRecord.Response.get("StatusCode"));
        Response originalResponse = chain.proceed(request);
        originalResponse.body().close();
        Response.Builder responseBuilder = originalResponse.newBuilder().code(recordStatusCode).message("-");
        for (Map.Entry<String, String> pair : networkCallRecord.Response.entrySet()) {
            void var11_13;
            if (pair.getKey().equals("StatusCode") || pair.getKey().equals("Body") || ((String)pair.getKey()).equals("Content-Length")) continue;
            String string = (String)pair.getValue();
            for (Map.Entry<String, String> rule : this.textReplacementRules.entrySet()) {
                if (rule.getValue() == null) continue;
                String string2 = var11_13.replaceAll(rule.getKey(), rule.getValue());
            }
            responseBuilder.addHeader((String)pair.getKey(), (String)var11_13);
        }
        String rawBody = networkCallRecord.Response.get("Body");
        if (rawBody != null) {
            for (Map.Entry entry : this.textReplacementRules.entrySet()) {
                if (entry.getValue() == null) continue;
                rawBody = rawBody.replaceAll((String)entry.getKey(), (String)entry.getValue());
            }
            String rawContentType = networkCallRecord.Response.get("content-type");
            String string = rawContentType == null ? "application/json; charset=utf-8" : rawContentType;
            ResponseBody responseBody = ResponseBody.create((MediaType)MediaType.parse((String)string), (byte[])rawBody.getBytes());
            responseBuilder.body(responseBody);
            responseBuilder.addHeader("Content-Length", String.valueOf(rawBody.getBytes("UTF-8").length));
        }
        Response newResponce = responseBuilder.build();
        return newResponce;
    }

    private void extractResponseData(Map<String, String> responseData, Response response) throws IOException {
        String bodyLoggingHeader;
        boolean bodyLogging;
        Map headers = response.headers().toMultimap();
        boolean addedRetryAfter = false;
        for (Map.Entry header : headers.entrySet()) {
            String headerValueToStore = (String)((List)header.getValue()).get(0);
            if (((String)header.getKey()).equalsIgnoreCase("location") || ((String)header.getKey()).equalsIgnoreCase("azure-asyncoperation")) {
                headerValueToStore = this.applyReplacementRule(headerValueToStore);
            }
            if (((String)header.getKey()).equalsIgnoreCase("retry-after")) {
                headerValueToStore = "0";
                addedRetryAfter = true;
            }
            responseData.put(((String)header.getKey()).toLowerCase(), headerValueToStore);
        }
        if (!addedRetryAfter) {
            responseData.put("retry-after", "0");
        }
        boolean bl = bodyLogging = (bodyLoggingHeader = response.request().header(BODY_LOGGING)) == null || Boolean.parseBoolean(bodyLoggingHeader);
        if (bodyLogging) {
            BufferedSource bufferedSource = response.body().source();
            bufferedSource.request(Long.MAX_VALUE);
            Buffer buffer = bufferedSource.buffer().clone();
            String content = null;
            if (response.header("Content-Encoding") == null) {
                content = new String(buffer.readString(Util.UTF_8));
            } else if (response.header("Content-Encoding").equalsIgnoreCase("gzip")) {
                GZIPInputStream gis = new GZIPInputStream(buffer.inputStream());
                content = CharStreams.toString((Readable)new InputStreamReader(gis));
                responseData.remove("Content-Encoding".toLowerCase());
                responseData.put("Content-Length".toLowerCase(), Integer.toString(content.length()));
            }
            if (content != null) {
                content = this.applyReplacementRule(content);
                responseData.put("Body", content);
            }
        }
    }

    private void readDataFromFile() throws IOException {
        File recordFile = this.getRecordFile(this.testName);
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.recordedData = (RecordedData)mapper.readValue(recordFile, RecordedData.class);
        System.out.println("Total records " + this.recordedData.getNetworkCallRecords().size());
    }

    private void writeDataToFile() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        File recordFile = this.getRecordFile(this.testName);
        recordFile.createNewFile();
        mapper.writeValue(recordFile, (Object)this.recordedData);
    }

    private File getRecordFile(String testName) {
        URL folderUrl = InterceptorManager.class.getClassLoader().getResource(".");
        File folderFile = new File(folderUrl.getPath() + RECORD_FOLDER);
        if (!folderFile.exists()) {
            folderFile.mkdir();
        }
        String filePath = folderFile.getPath() + "/" + testName + ".json";
        System.out.println("==> Playback file path: " + filePath);
        return new File(filePath);
    }

    private String applyReplacementRule(String text) {
        for (Map.Entry<String, String> rule : this.textReplacementRules.entrySet()) {
            if (rule.getValue() == null) continue;
            text = text.replaceAll(rule.getKey(), rule.getValue());
        }
        return text;
    }

    private String removeHost(String url) {
        URI uri = URI.create(url);
        return String.format("%s?%s", uri.getPath(), uri.getQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushVariable(String variable) {
        if (this.isRecordMode()) {
            LinkedList<String> linkedList = this.recordedData.getVariables();
            synchronized (linkedList) {
                this.recordedData.getVariables().add(variable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String popVariable() {
        LinkedList<String> linkedList = this.recordedData.getVariables();
        synchronized (linkedList) {
            return this.recordedData.getVariables().remove();
        }
    }
}

