/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.core;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.arm.core.AzureTestCredentials;
import com.microsoft.azure.arm.core.InterceptorManager;
import com.microsoft.azure.arm.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.arm.utils.SdkContext;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.LogLevel;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.interceptors.LoggingInterceptor;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Proxy;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class TestBase {
    private PrintStream out;
    private String baseUri;
    protected static final String ZERO_SUBSCRIPTION = "00000000-0000-0000-0000-000000000000";
    protected static final String ZERO_TENANT = "00000000-0000-0000-0000-000000000000";
    private static final String PLAYBACK_URI_BASE = "http://localhost:";
    protected static String playbackUri = null;
    private final RunCondition runCondition;
    private static TestMode testMode = null;
    @Rule
    public TestName testName = new TestName();
    protected InterceptorManager interceptorManager = null;

    public static String generateRandomResourceName(String prefix, int maxLen) {
        return SdkContext.randomResourceName((String)prefix, (int)maxLen);
    }

    protected TestBase() {
        this(RunCondition.BOTH);
    }

    protected TestBase(RunCondition runCondition) {
        this.runCondition = runCondition;
    }

    private String shouldCancelTest(boolean isPlaybackMode) {
        switch (this.runCondition) {
            case MOCK_ONLY: {
                return !isPlaybackMode ? "Test configured to run only as mocked, not live." : null;
            }
            case LIVE_ONLY: {
                return isPlaybackMode ? "Test configured to run only as live, not mocked." : null;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initTestMode() throws IOException {
        String azureTestMode = System.getenv("AZURE_TEST_MODE");
        if (azureTestMode != null) {
            if (azureTestMode.equalsIgnoreCase("Record")) {
                testMode = TestMode.RECORD;
                return;
            } else if (azureTestMode.equalsIgnoreCase("Playback")) {
                testMode = TestMode.PLAYBACK;
                return;
            } else {
                if (!azureTestMode.equalsIgnoreCase("None")) throw new IOException("Unknown AZURE_TEST_MODE: " + azureTestMode);
                testMode = TestMode.NONE;
            }
            return;
        } else {
            testMode = TestMode.PLAYBACK;
        }
    }

    private static void initPlaybackUri() throws IOException {
        if (TestBase.isPlaybackMode()) {
            Properties mavenProps = new Properties();
            InputStream in = TestBase.class.getResourceAsStream("/maven.properties");
            if (in == null) {
                throw new IOException("The file \"maven.properties\" has not been generated yet. Please execute \"mvn compile\" to generate the file.");
            }
            mavenProps.load(in);
            String port = mavenProps.getProperty("playbackServerPort");
            playbackUri = PLAYBACK_URI_BASE + port;
        } else {
            playbackUri = "http://localhost:1234";
        }
    }

    public static boolean isPlaybackMode() {
        if (testMode == null) {
            try {
                TestBase.initTestMode();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Can't init test mode.");
            }
        }
        return testMode == TestMode.PLAYBACK;
    }

    public static boolean isRecordMode() {
        return !TestBase.isPlaybackMode();
    }

    private static void printThreadInfo(String what) {
        long id = Thread.currentThread().getId();
        String name = Thread.currentThread().getName();
        System.out.println(String.format("\n***\n*** [%s:%s] - %s\n***\n", name, id, what));
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        TestBase.printThreadInfo("beforeClass");
        TestBase.initTestMode();
        TestBase.initPlaybackUri();
    }

    @Before
    public void beforeTest() throws IOException {
        String defaultSubscription;
        RestClient restClient;
        AzureTestCredentials credentials;
        TestBase.printThreadInfo(String.format("%s: %s", "beforeTest", this.testName.getMethodName()));
        String skipMessage = this.shouldCancelTest(TestBase.isPlaybackMode());
        Assume.assumeTrue((String)skipMessage, (skipMessage == null ? 1 : 0) != 0);
        this.interceptorManager = InterceptorManager.create(this.testName.getMethodName(), testMode);
        if (TestBase.isPlaybackMode()) {
            credentials = new AzureTestCredentials(playbackUri, "00000000-0000-0000-0000-000000000000", true);
            restClient = this.buildRestClient(new RestClient.Builder().withBaseUrl(playbackUri + "/").withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withCredentials((ServiceClientCredentials)credentials).withLogLevel(LogLevel.NONE).withNetworkInterceptor((Interceptor)new LoggingInterceptor(LogLevel.BODY_AND_HEADERS)).withNetworkInterceptor(this.interceptorManager.initInterceptor()).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()), true);
            defaultSubscription = "00000000-0000-0000-0000-000000000000";
            this.interceptorManager.addTextReplacementRule("http://localhost:1234", playbackUri);
            System.out.println(playbackUri);
            this.out = System.out;
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }));
        } else {
            Proxy proxy;
            if (System.getenv("AZURE_AUTH_LOCATION") != null) {
                File credFile = new File(System.getenv("AZURE_AUTH_LOCATION"));
                credentials = ApplicationTokenCredentials.fromFile((File)credFile);
            } else {
                String clientId = System.getenv("AZURE_CLIENT_ID");
                String tenantId = System.getenv("AZURE_TENANT_ID");
                String clientSecret = System.getenv("AZURE_CLIENT_SECRET");
                String subscriptionId = System.getenv("AZURE_SUBSCRIPTION_ID");
                if (clientId == null || tenantId == null || clientSecret == null || subscriptionId == null) {
                    throw new IllegalArgumentException("When running tests in record mode either 'AZURE_AUTH_LOCATION' or 'AZURE_CLIENT_ID, AZURE_TENANT_ID, AZURE_CLIENT_SECRET and AZURE_SUBSCRIPTION_ID' needs to be set");
                }
                credentials = new ApplicationTokenCredentials(clientId, tenantId, clientSecret, AzureEnvironment.AZURE);
                credentials.withDefaultSubscriptionId(subscriptionId);
            }
            RestClient.Builder builder = new RestClient.Builder().withBaseUrl(this.baseUri()).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withCredentials((ServiceClientCredentials)credentials).withLogLevel(LogLevel.NONE).withReadTimeout(3L, TimeUnit.MINUTES).withNetworkInterceptor((Interceptor)new LoggingInterceptor(LogLevel.BODY_AND_HEADERS));
            if (!this.interceptorManager.isNoneMode()) {
                builder.withNetworkInterceptor(this.interceptorManager.initInterceptor());
            }
            if ((proxy = this.proxy()) != null) {
                builder.withProxy(proxy);
            }
            restClient = this.buildRestClient(builder.withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()), false);
            defaultSubscription = credentials.defaultSubscriptionId();
            this.interceptorManager.addTextReplacementRule(defaultSubscription, "00000000-0000-0000-0000-000000000000");
            this.interceptorManager.addTextReplacementRule(credentials.domain(), "00000000-0000-0000-0000-000000000000");
            this.interceptorManager.addTextReplacementRule(this.baseUri(), playbackUri + "/");
            this.interceptorManager.addTextReplacementRule("https://graph.windows.net/", playbackUri + "/");
        }
        this.initializeClients(restClient, defaultSubscription, credentials.domain());
    }

    @After
    public void afterTest() throws IOException {
        if (this.shouldCancelTest(TestBase.isPlaybackMode()) != null) {
            return;
        }
        this.cleanUpResources();
        this.interceptorManager.finalizeInterceptor();
    }

    protected void addTextReplacementRule(String from, String to) {
        this.interceptorManager.addTextReplacementRule(from, to);
    }

    protected void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    protected String baseUri() {
        if (this.baseUri != null) {
            return this.baseUri;
        }
        return AzureEnvironment.AZURE.url((Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER);
    }

    protected RestClient buildRestClient(RestClient.Builder builder, boolean isMocked) {
        return builder.build();
    }

    protected abstract void initializeClients(RestClient var1, String var2, String var3) throws IOException;

    protected abstract void cleanUpResources();

    protected Proxy proxy() {
        return null;
    }

    public static enum TestMode {
        PLAYBACK,
        RECORD,
        NONE;

    }

    protected static enum RunCondition {
        MOCK_ONLY,
        LIVE_ONLY,
        BOTH;

    }
}

