/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.dag;

import com.google.common.collect.Sets;
import com.microsoft.azure.arm.dag.IPancake;
import com.microsoft.azure.arm.dag.IPasta;
import com.microsoft.azure.arm.dag.PancakeImpl;
import com.microsoft.azure.arm.dag.PastaImpl;
import com.microsoft.azure.arm.dag.TaskGroup;
import com.microsoft.azure.arm.dag.TaskGroupTerminateOnErrorStrategy;
import com.microsoft.azure.arm.model.Indexable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import rx.Observable;
import rx.exceptions.CompositeException;
import rx.functions.Func1;

public class DAGErrorTests {
    @Test
    public void testTerminateOnInProgressTaskCompletion() {
        PancakeImpl pancakeM = new PancakeImpl("M", 250L);
        PancakeImpl pancakeN = new PancakeImpl("N", 250L);
        PancakeImpl pancakeK = new PancakeImpl("K", 250L);
        PancakeImpl pancakeQ = new PancakeImpl("Q", 8000L);
        PancakeImpl pancakeI = new PancakeImpl("I", 8000L);
        PancakeImpl pancakeJ = new PancakeImpl("J", 250L);
        pancakeJ.withInstantPancake(pancakeM);
        pancakeJ.withInstantPancake(pancakeN);
        PancakeImpl pancakeP = new PancakeImpl("P", 250L);
        pancakeP.withDelayedPancake(pancakeQ);
        PancakeImpl pancakeH = new PancakeImpl("H", 250L);
        pancakeH.withInstantPancake(pancakeI);
        PancakeImpl pancakeA = new PancakeImpl("A", 250L);
        PancakeImpl pancakeL = new PancakeImpl("L", 250L);
        pancakeL.withInstantPancake(pancakeP);
        PancakeImpl pancakeB = new PancakeImpl("B", 4000L, true);
        pancakeB.withInstantPancake(pancakeA);
        PancakeImpl pancakeC = new PancakeImpl("C", 250L);
        pancakeC.withInstantPancake(pancakeA);
        PancakeImpl pancakeD = new PancakeImpl("D", 250L);
        pancakeD.withInstantPancake(pancakeB);
        PancakeImpl pancakeG = new PancakeImpl("G", 250L);
        pancakeG.withInstantPancake(pancakeC);
        pancakeG.withDelayedPancake(pancakeL);
        PancakeImpl pancakeE = new PancakeImpl("E", 250L);
        pancakeE.withInstantPancake(pancakeB);
        pancakeE.withInstantPancake(pancakeG);
        PancakeImpl pancakeF = new PancakeImpl("F", 250L);
        pancakeF.withInstantPancake(pancakeD);
        pancakeF.withInstantPancake(pancakeE);
        pancakeF.withInstantPancake(pancakeH);
        pancakeA.withDelayedPancake(pancakeJ);
        pancakeA.withDelayedPancake(pancakeK);
        HashSet<String> expectedToSee = new HashSet<String>();
        expectedToSee.add("M");
        expectedToSee.add("N");
        expectedToSee.add("K");
        expectedToSee.add("Q");
        expectedToSee.add("I");
        expectedToSee.add("J");
        expectedToSee.add("A");
        expectedToSee.add("C");
        final HashSet seen = new HashSet();
        final ArrayList exceptions = new ArrayList();
        TaskGroup pancakeFtg = pancakeF.taskGroup();
        TaskGroup.InvocationContext context = pancakeFtg.newInvocationContext().withTerminateOnErrorStrategy(TaskGroupTerminateOnErrorStrategy.TERMINATE_ON_IN_PROGRESS_TASKS_COMPLETION);
        IPancake rootPancake = (IPancake)pancakeFtg.invokeAsync(context).map((Func1)new Func1<Indexable, IPancake>(){

            public IPancake call(Indexable indexable) {
                IPancake pancake = (IPancake)indexable;
                System.out.println("map.onNext: " + pancake.name());
                seen.add(pancake.name());
                return pancake;
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<IPancake>>(){

            public Observable<IPancake> call(Throwable throwable) {
                System.out.println("map.onErrorResumeNext: " + throwable);
                exceptions.add(throwable);
                return Observable.empty();
            }
        }).toBlocking().last();
        Assert.assertTrue((boolean)Sets.difference(expectedToSee, seen).isEmpty());
        Assert.assertEquals((long)exceptions.size(), (long)1L);
        Assert.assertTrue((boolean)(exceptions.get(0) instanceof RuntimeException));
        RuntimeException runtimeException = (RuntimeException)exceptions.get(0);
        Assert.assertTrue((boolean)runtimeException.getMessage().equalsIgnoreCase("B"));
    }

    @Test
    public void testTerminateOnHittingLcaTask() {
        PastaImpl pastaM = new PastaImpl("M", 250L);
        PastaImpl pastaN = new PastaImpl("N", 250L);
        PastaImpl pastaK = new PastaImpl("K", 250L);
        PastaImpl pastaQ = new PastaImpl("Q", 8000L);
        PastaImpl pastaI = new PastaImpl("I", 8000L);
        PastaImpl pastaJ = new PastaImpl("J", 250L);
        pastaJ.withInstantPasta(pastaM);
        pastaJ.withInstantPasta(pastaN);
        PastaImpl pastaP = new PastaImpl("P", 250L);
        pastaP.withDelayedPasta(pastaQ);
        PastaImpl pastaH = new PastaImpl("H", 250L);
        pastaH.withInstantPasta(pastaI);
        PastaImpl pastaA = new PastaImpl("A", 250L);
        PastaImpl pastaL = new PastaImpl("L", 250L);
        pastaL.withInstantPasta(pastaP);
        PastaImpl pastaB = new PastaImpl("B", 4000L, true);
        pastaB.withInstantPasta(pastaA);
        PastaImpl pastaC = new PastaImpl("C", 250L);
        pastaC.withInstantPasta(pastaA);
        PastaImpl pastaD = new PastaImpl("D", 250L);
        pastaD.withInstantPasta(pastaB);
        PastaImpl pastaG = new PastaImpl("G", 250L);
        pastaG.withInstantPasta(pastaC);
        pastaG.withDelayedPasta(pastaL);
        PastaImpl pastaE = new PastaImpl("E", 250L);
        pastaE.withInstantPasta(pastaB);
        pastaE.withInstantPasta(pastaG);
        PastaImpl pastaF = new PastaImpl("F", 250L);
        pastaF.withInstantPasta(pastaD);
        pastaF.withInstantPasta(pastaE);
        pastaF.withInstantPasta(pastaH);
        pastaA.withDelayedPasta(pastaJ);
        pastaA.withDelayedPasta(pastaK);
        HashSet<String> expectedToSee = new HashSet<String>();
        expectedToSee.add("M");
        expectedToSee.add("N");
        expectedToSee.add("K");
        expectedToSee.add("Q");
        expectedToSee.add("I");
        expectedToSee.add("J");
        expectedToSee.add("P");
        expectedToSee.add("H");
        expectedToSee.add("A");
        expectedToSee.add("L");
        expectedToSee.add("C");
        expectedToSee.add("G");
        final HashSet seen = new HashSet();
        final ArrayList exceptions = new ArrayList();
        TaskGroup pastaFtg = pastaF.taskGroup();
        TaskGroup.InvocationContext context = pastaFtg.newInvocationContext().withTerminateOnErrorStrategy(TaskGroupTerminateOnErrorStrategy.TERMINATE_ON_HITTING_LCA_TASK);
        IPasta rootPasta = (IPasta)pastaFtg.invokeAsync(context).map((Func1)new Func1<Indexable, IPasta>(){

            public IPasta call(Indexable indexable) {
                IPasta pasta = (IPasta)indexable;
                System.out.println("map.onNext: " + pasta.name());
                seen.add(pasta.name());
                return pasta;
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<IPasta>>(){

            public Observable<IPasta> call(Throwable throwable) {
                System.out.println("map.onErrorResumeNext: " + throwable);
                exceptions.add(throwable);
                return Observable.empty();
            }
        }).toBlocking().last();
        Assert.assertTrue((boolean)Sets.difference(expectedToSee, seen).isEmpty());
        Assert.assertEquals((long)exceptions.size(), (long)1L);
        Assert.assertTrue((boolean)(exceptions.get(0) instanceof RuntimeException));
        RuntimeException runtimeException = (RuntimeException)exceptions.get(0);
        Assert.assertTrue((boolean)runtimeException.getMessage().equalsIgnoreCase("B"));
    }

    @Test
    public void testCompositeError() {
        PancakeImpl pancakeM = new PancakeImpl("M", 250L);
        PancakeImpl pancakeN = new PancakeImpl("N", 250L);
        PancakeImpl pancakeK = new PancakeImpl("K", 250L);
        PancakeImpl pancakeQ = new PancakeImpl("Q", 250L);
        PancakeImpl pancakeI = new PancakeImpl("I", 250L);
        PancakeImpl pancakeJ = new PancakeImpl("J", 250L);
        pancakeJ.withInstantPancake(pancakeM);
        pancakeJ.withInstantPancake(pancakeN);
        PancakeImpl pancakeP = new PancakeImpl("P", 250L);
        pancakeP.withDelayedPancake(pancakeQ);
        PancakeImpl pancakeH = new PancakeImpl("H", 250L);
        pancakeH.withInstantPancake(pancakeI);
        PancakeImpl pancakeA = new PancakeImpl("A", 250L);
        PancakeImpl pancakeL = new PancakeImpl("L", 250L);
        pancakeL.withInstantPancake(pancakeP);
        PancakeImpl pancakeB = new PancakeImpl("B", 3500L, true);
        pancakeB.withInstantPancake(pancakeA);
        PancakeImpl pancakeC = new PancakeImpl("C", 250L);
        pancakeC.withInstantPancake(pancakeA);
        PancakeImpl pancakeD = new PancakeImpl("D", 250L);
        pancakeD.withInstantPancake(pancakeB);
        PancakeImpl pancakeG = new PancakeImpl("G", 250L, true);
        pancakeG.withInstantPancake(pancakeC);
        pancakeG.withDelayedPancake(pancakeL);
        PancakeImpl pancakeE = new PancakeImpl("E", 250L);
        pancakeE.withInstantPancake(pancakeB);
        pancakeE.withInstantPancake(pancakeG);
        PancakeImpl pancakeF = new PancakeImpl("F", 250L);
        pancakeF.withInstantPancake(pancakeD);
        pancakeF.withInstantPancake(pancakeE);
        pancakeF.withInstantPancake(pancakeH);
        pancakeA.withDelayedPancake(pancakeJ);
        pancakeA.withDelayedPancake(pancakeK);
        TreeSet<String> expectedToSee = new TreeSet<String>();
        expectedToSee.add("M");
        expectedToSee.add("N");
        expectedToSee.add("K");
        expectedToSee.add("Q");
        expectedToSee.add("I");
        expectedToSee.add("J");
        expectedToSee.add("P");
        expectedToSee.add("H");
        expectedToSee.add("A");
        expectedToSee.add("L");
        expectedToSee.add("C");
        final TreeSet seen = new TreeSet();
        final ArrayList exceptions = new ArrayList();
        TaskGroup pancakeFtg = pancakeF.taskGroup();
        TaskGroup.InvocationContext context = pancakeFtg.newInvocationContext().withTerminateOnErrorStrategy(TaskGroupTerminateOnErrorStrategy.TERMINATE_ON_IN_PROGRESS_TASKS_COMPLETION);
        IPancake rootPancake = (IPancake)pancakeFtg.invokeAsync(context).map((Func1)new Func1<Indexable, IPancake>(){

            public IPancake call(Indexable indexable) {
                IPancake pancake = (IPancake)indexable;
                String name = pancake.name();
                System.out.println("map.onNext:" + name);
                seen.add(name);
                return pancake;
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<IPancake>>(){

            public Observable<IPancake> call(Throwable throwable) {
                System.out.println("map.onErrorResumeNext:" + throwable);
                exceptions.add(throwable);
                return Observable.empty();
            }
        }).toBlocking().last();
        Assert.assertTrue((boolean)Sets.difference(expectedToSee, seen).isEmpty());
        Assert.assertEquals((long)exceptions.size(), (long)1L);
        Assert.assertTrue((boolean)(exceptions.get(0) instanceof CompositeException));
        CompositeException compositeException = (CompositeException)exceptions.get(0);
        Assert.assertEquals((long)compositeException.getExceptions().size(), (long)2L);
        for (Throwable throwable : compositeException.getExceptions()) {
            String message = throwable.getMessage();
            Assert.assertTrue((message.equalsIgnoreCase("B") || message.equalsIgnoreCase("G") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testErrorOnRoot() {
        PancakeImpl pancakeM = new PancakeImpl("M", 250L);
        PancakeImpl pancakeN = new PancakeImpl("N", 250L);
        PancakeImpl pancakeK = new PancakeImpl("K", 250L);
        PancakeImpl pancakeQ = new PancakeImpl("Q", 250L);
        PancakeImpl pancakeI = new PancakeImpl("I", 250L);
        PancakeImpl pancakeJ = new PancakeImpl("J", 250L);
        pancakeJ.withInstantPancake(pancakeM);
        pancakeJ.withInstantPancake(pancakeN);
        PancakeImpl pancakeP = new PancakeImpl("P", 250L);
        pancakeP.withDelayedPancake(pancakeQ);
        PancakeImpl pancakeH = new PancakeImpl("H", 250L);
        pancakeH.withInstantPancake(pancakeI);
        PancakeImpl pancakeA = new PancakeImpl("A", 250L);
        PancakeImpl pancakeL = new PancakeImpl("L", 250L);
        pancakeL.withInstantPancake(pancakeP);
        PancakeImpl pancakeB = new PancakeImpl("B", 250L);
        pancakeB.withInstantPancake(pancakeA);
        PancakeImpl pancakeC = new PancakeImpl("C", 250L);
        pancakeC.withInstantPancake(pancakeA);
        PancakeImpl pancakeD = new PancakeImpl("D", 250L);
        pancakeD.withInstantPancake(pancakeB);
        PancakeImpl pancakeG = new PancakeImpl("G", 250L);
        pancakeG.withInstantPancake(pancakeC);
        pancakeG.withDelayedPancake(pancakeL);
        PancakeImpl pancakeE = new PancakeImpl("E", 250L);
        pancakeE.withInstantPancake(pancakeB);
        pancakeE.withInstantPancake(pancakeG);
        PancakeImpl pancakeF = new PancakeImpl("F", 250L, true);
        pancakeF.withInstantPancake(pancakeD);
        pancakeF.withInstantPancake(pancakeE);
        pancakeF.withInstantPancake(pancakeH);
        pancakeA.withDelayedPancake(pancakeJ);
        pancakeA.withDelayedPancake(pancakeK);
        HashSet<String> expectedToSee = new HashSet<String>();
        expectedToSee.add("M");
        expectedToSee.add("N");
        expectedToSee.add("K");
        expectedToSee.add("Q");
        expectedToSee.add("I");
        expectedToSee.add("J");
        expectedToSee.add("P");
        expectedToSee.add("H");
        expectedToSee.add("A");
        expectedToSee.add("L");
        expectedToSee.add("B");
        expectedToSee.add("C");
        expectedToSee.add("D");
        expectedToSee.add("G");
        expectedToSee.add("E");
        final HashSet seen = new HashSet();
        final ArrayList exceptions = new ArrayList();
        TaskGroup pancakeFtg = pancakeF.taskGroup();
        TaskGroup.InvocationContext context = pancakeFtg.newInvocationContext().withTerminateOnErrorStrategy(TaskGroupTerminateOnErrorStrategy.TERMINATE_ON_IN_PROGRESS_TASKS_COMPLETION);
        IPancake rootPancake = (IPancake)pancakeFtg.invokeAsync(context).map((Func1)new Func1<Indexable, IPancake>(){

            public IPancake call(Indexable indexable) {
                IPancake pancake = (IPancake)indexable;
                seen.add(pancake.name());
                System.out.println("map.onNext:" + pancake.name());
                return pancake;
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<IPancake>>(){

            public Observable<IPancake> call(Throwable throwable) {
                System.out.println("map.onErrorResumeNext:" + throwable);
                exceptions.add(throwable);
                return Observable.empty();
            }
        }).toBlocking().last();
        Assert.assertTrue((boolean)Sets.difference(expectedToSee, seen).isEmpty());
        Assert.assertEquals((long)exceptions.size(), (long)1L);
        Assert.assertTrue((boolean)(exceptions.get(0) instanceof RuntimeException));
        RuntimeException runtimeException = (RuntimeException)exceptions.get(0);
        Assert.assertTrue((boolean)runtimeException.getMessage().equalsIgnoreCase("F"));
    }
}

